package com.baijia.tianxiao.dal.finance.dao.impl;

import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/7
 * Time: 下午7:00
 * To change this template use File | Settings | File Templates.
 */
@Repository
@Slf4j
public class TxFinanceInfoDaoImpl extends JdbcTemplateDaoSupport<TxxFinanceInfo> implements TxFinanceInfoDao {

    @Override
    public List<TxxFinanceInfo> list(TxxFinanceInfo txFinanceInfo, String key, PageDto page, String... queryProp) {

        SingleSqlBuilder<TxxFinanceInfo> builder = this.createSqlBuilder(queryProp);
        builder.eq("orgId", txFinanceInfo.getOrgId());
        if (StringUtils.isNotEmpty(key)&&StringUtils.isNotEmpty(key.trim())) {
            builder.like("purchaseId", key.trim(), MatchMode.ANYWHERE);
        }
        if (CollectionUtils.isNotEmpty(txFinanceInfo.getOpTypes())) {
            builder.in("opType", txFinanceInfo.getOpTypes());
        }
        if (CollectionUtils.isNotEmpty(txFinanceInfo.getOpTos())) {
            builder.in("opTo", txFinanceInfo.getOpTos());
        }
        if (CollectionUtils.isNotEmpty(txFinanceInfo.getPayTypes())) {
            builder.in("payType", txFinanceInfo.getPayTypes());
        }
        //设置每页显示多少条
        //page = new PageDto();
        //page.setPageSize(10);
        if (page != null) {
            builder.setPage(page);
        }
        if (txFinanceInfo.getStartTime() != null && txFinanceInfo.getEndTime() != null) {
            builder.ge("createTime", txFinanceInfo.getStartTime());
            builder.lt("createTime", txFinanceInfo.getEndTime());
        }

        if (txFinanceInfo.getStartBalance() != null) {
            builder.ge("opMoney", txFinanceInfo.getStartBalance().doubleValue());
        }
        if (txFinanceInfo.getEndBalance() != null) {
            builder.le("opMoney", txFinanceInfo.getEndBalance().doubleValue());
        }
        //用于app端分页
        //if(txFinanceInfo.getId() != null){
        //   builder.ge("id", txFinanceInfo.getId());
        //}
        builder.desc("createTime","id");
        log.info("TxxFinanceInfo list = {},{}",builder.toSql(),builder.collectConditionValue());
        return queryList(builder);
    }
}
