/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.export.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年5月6日
* @desc 
 */
@Data
@Entity
@Table(name = "tx_statistic_data", catalog = "yunying")
public class TXStatisticData {
    @Id
    @GeneratedValue
    @Column
    private long id;
    
    @Column(name = "shortname")
    private String orgShortName;
    @Column
    private Integer orgNumber;

    @Column
    private int backlogTotal;
    @Column
    private int backlogFinish;
    @Column
    private int backlogExpire;
    
    @Column
    private int clueTotal;
    @Column
    private int clueWechat;
    @Column
    private int clueReserve; // 预约留单
    @Column
    private int clueCall; // 400电话新增

    @Column
    private int consultUserTotal; // 意向学员

    @Column
    private int incrementStudentTotal; // 学员

    @Column
    private int isWechatAuthorizer; // 是否有微信公众号
    @Column
    private int isWechatMenu; // 是否有公众号菜单
    @Column
    private int wechatFansTotal; /// 粉丝数

    @Column
    private int courseTotal; // 微课数

    @Column
    private int arrangedClassTotal; // 排课数
    @Column
    private int lessonTotal; // 课节数

    @Column
    private int courseSmsTotal; // 课表数

    @Column
    private double incomeSum; // 收入总额
    @Column
    private int incomeTotal; // 收入笔数

    @Column
    private int signLessonTotal; // 签到课节数
    @Column
    private int signStudentTotal; // 签到学生数

    @Column
    private double cashPurchaseSum; // 提现

    @Column
    private int commentByStudent; // 学生评价
    @Column
    private int commentByTeacher; // 老师评价

    @Column
    private int teacherTotal; // 老师数
    @Column
    private int roomTotal; // 教室数

    @Column
    private int activityTotal; // 发活动数
    @Column
    private int activityAccessTotal; // 发活动访问量
    @Column
    private int activityEnrollTotal; // 发活动报名数

    @Column
    private int drawActivityTotal; // 抽奖活动数
    @Column
    private int drawUserTotal; // 抽奖活动参与数
    @Column
    private int drawWinnerTotal; // 抽奖中奖人数

    @Column
    private int voteActivityTotal; // 投票活动数
    @Column
    private int voteAccessTotal; // 投票活动参与人数
    @Column
    private int voteTotal; // 投票数

    @Column
    private int referralActivityTotal; // 转介绍活动数
    @Column
    private int referralAccessTotal; // 转介绍访问人数
    @Column
    private int brokerTotal; // 转介绍经纪人数
    @Column
    private int referralTotal; // 转介绍人数

    @Column
    private int groupMsgTotal; // 群发消息数
    @Column
    private int msgReceiverTotal; // 群发消息接受人数

    @Column(name = "is_use_homepage")
    private int isUseHomePage; // 是否使用主页模板

    @Column(name = "uv_total")
    private int uvTotal; // UV使用量
    @Column(name = "pv_total")
    private int pvTotal; // PV使用量

    @Column
    private int loginTotal; // 机构登录次数

    @Column(name = "wechat_authorizer_of_student_total")
    private int wechatAuthorizerOfStudentTotal; // 绑定微信公众号学生数

    @Column
    private int smsTotal; // 短信数
    
    //400电话
    @Column
    private int orgCallRecordCount;    //400通话次数
    @Column
    private int orgCallRecordTime;     //400电话通话时长
    
    @Column
    private int way;     //查询数据方式：0按天，1按周，2按月，3截至今日
    
    @Column
    private int commentSystemTotal;
    
    @Column
    private int commentNotSystemTotal;
    
    @Column(name = "compus_type_desc")
    private String compusTypeDesc;  //机构主分校区类型
    
    @Column(name = "sub_orgNumber")
    private int subOrgNumber;  
    
    @Column(name = "account_type_desc")
    private String accountTypeDesc;
    
    @Column(name = "service_type_desc")
    private String serviceTypeDesc;
    
    @Column(name = "student_total")
    private int studentTotal; 
    
    @Column(name = "study_student_total")
    private int studyStudentTotal;
    
    @Column(name = "call_service_count")
    private int callServiceCount;
    
    @Column(name = "call_service_duration")
    private int callServiceDuration;
    
    @Column(name = "comment_student_system_total")
    private int commentStudentSystemTotal;
    
    @Column(name = "comment_student_not_system_total")
    private int commentStudentNotSystemTotal;
    
    @Column(name = "comment_consult_system_total")
    private int commentConsultSystemTotal;
    
    @Column(name = "comment_consult_not_system_total")
    private int commentConsultNotSystemTotal;
    
    @Column(name = "login_account_total")
    private int loginAccountTotal;
    @Column(name = "login_device_total")
    private int loginDeviceTotal;
    
    @Column(name = "org_vip_level_str")
    private String orgVipLevelStr;
    
    @Column(name = "org_open_total")
    private int orgOpenTotal;    //打开次数
    @Column
    private Date updateTime;
    
    @Column
    private String startDate;    //插入数据时间范围开始时间
    @Column
    private String curDate;      //插入数据时间结束时间

}
