/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.export.dao.impl;

import com.baijia.tianxiao.dal.export.dao.TXStatisticDataDao;
import com.baijia.tianxiao.dal.export.po.TXStatisticData;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

/**
 * @author gaodan
 * @createdate 2016年5月6日
* @desc 
 */
@Repository
public class TXStatisticDataDaoImpl extends JdbcTemplateDaoSupport<TXStatisticData> implements TXStatisticDataDao{

    public TXStatisticDataDaoImpl(){
        super(TXStatisticData.class);
    }
    
    @Override
    public void addTXStatisticData(TXStatisticData txStatisticData) {
        save(txStatisticData);
    }

    @Override
    public void updateTXStatisticData(TXStatisticData txStatisticData) {
        update(txStatisticData, false);
    }

    @Override
    public TXStatisticData getTXStatisticDataByOrgNumber(Integer orgNumber, String curDate, Integer way) {
        SingleSqlBuilder<TXStatisticData>  builder = createSqlBuilder();
        builder.eq("orgNumber", orgNumber);
        builder.eq("curDate", curDate);
        builder.eq("way", way);
        return uniqueResult(builder);
    }
    
    

}
