
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.commons.configs;

import java.util.Map;

import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 10, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class GenericsConfiguration extends KeyHolder {

    public static final Map<String, ConfigParser<?>> parsers = Maps.newHashMap();

    private static Map<String, Object> configs = Maps.newConcurrentMap();

    public static void setConfiguration(String key, String configValueJson) {
        if (GenericsUtils.isNullOrEmpty(configValueJson) || GenericsUtils.isNullOrEmpty(configValueJson)) {
            return;
        }
        ConfigParser<?> parser = parsers.get(key);
        Object newValue = configValueJson;
        if (parser != null) {
            newValue = parser.parserConfig(configValueJson);
        }
        Object oldValue = configs.put(key, newValue);
        log.info("old value {}  ----> new Value {} ", oldValue, newValue);
    }

    public static void registeParser(Class<? extends ConfigParser<?>> parserClass) {
        if (parserClass == null) {
            return;
        }
        try {
            ConfigParser<?> newInstance = parserClass.newInstance();
            parsers.put(newInstance.getKey(), newInstance);
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean needForceReGetJsApiTicket() {
        Object object = configs.get(FORCED_RE_GET_JS_API);
        return object == null ? false : (object instanceof Boolean) ? (Boolean) object : false;
    }

}
