/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.callservice.po;

import com.baijia.tianxiao.dal.callservice.constant.PartyCallType;
import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * @title CallServiceInfo
 * @desc TODO
 * @author cxm
 * @date 2015年12月5日
 * @version 1.0
 */
@Entity
@Table(name = "callservice_info", catalog = "yunying")
@Data
public class CallServiceInfo {

    @Id
    @GeneratedValue
    private Long id;

    @Column(name = "call_subscriber")
    private Long callSubscriber;// 主叫方id

    @Column
    private Long calledParty;// 被叫方id

    @Column
    private String callSubscriberNum;//  主叫电话

    @Column
    private String calledPartyNum;// 被叫电话

    @Column
    private String uniqueId;// 双呼的唯一id

    @Column
    private Integer status;// 状态

    @Column
    private Integer result;// 原因

    @Column
    private Integer cdrStatus;// cdr的状态值

    @Column
    private Date createTime;// 记录创建时间

    @Column
    private Date updateTime;// 更新时间

    @Column
    private Date callStart;// 通话开始时间

    @Column
    private Date callEnd;// 通话结束时间

    @Column
    private int duration;// 持续通话时间[冗余]

    @Column
    private String month;// 电话发生年月[冗余]

    @Column
    private Long storageId;// 录音记录Id

    /**
     * 呼叫类型,参考 {@link PartyCallType}
     */
    @Column
    private Integer callType;

    /**
     * 收到挂机推送以后回调
     */
    @Column
    private String callback = "";

}
