/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.callservice.po;

import com.baijia.tianxiao.sqlbuilder.annotation.*;
import lombok.Data;

import java.util.Date;

/**
 * @title CallserviceCallbackRecord
 * @desc thebestisyettocome
 * @author weihongyan
 * @date Sep 5, 2016
 * @version null
 */
@Data
@Entity(dataSourceBeanName = "yunyingDataSource")
@Table(catalog = "yunying", name = "tx_callservice_record")
public class CallServiceCallbackRecord {
    @Id
    @GeneratedValue
    private Integer id;// 主键
    @Column(name = "org_id")
    private Integer orgId;// 机构id
    @Column(name = "call_status")
    private Integer callStatus;// 1主叫时长为0时->机构未接听；2被叫时长为0时->用户未接听；0主叫被叫时长都不为0时->双方接听
    @Column(name = "connect_minutes")
    private Integer connectMinutes;// 通话分钟数：单位分钟，被叫时长向上取整（不足一分钟的部分变为一分）
    @Column(name = "total_minutes")
    private Integer totalMinutes;// 总分钟数：被叫时长向上取整+主叫时长向上取整（为了计算我们向容联支付的成本）,注意是分别取整
    @Column(name = "called_app_Id") 
    private String calledAppId;// 应用ID
    @Column(name = "called_beginCallTime")
    private Date calledBeginCallTime;// 开始呼叫被叫时间
    @Column(name = "called_byetype")
    private String calledByetype;// 挂机类型
    @Column(name = "called_callSid")
    private String calledCallSid;// 回拨接口请求后响应返回的callSid参数，一路呼叫的唯一标识
    @Column(name = "called_called")
    private String calledCalled;// 学员电话
    @Column(name = "called_caller")
    private String calledCaller;// 机构双呼电话
    @Column(name = "called_duration")
    private Integer calledDuration;// 双方接通秒数
    @Column(name = "called_endtime")
    private Date calledEndtime;// 结束时间，被叫挂机时间，如果被叫未接听则为空。
    @Column(name = "called_lineNumber")
    private String calledLineNumber;// 接口数据
    @Column(name = "called_lostRate")
    private String calledLostRate;// 接口数据
    @Column(name = "called_ringingBeginTime")
    private Date calledRingingBeginTime;// 被叫开始振铃时间
    @Column(name = "called_ringingEndTime")
    private Date calledRingingEndTime;// 被叫结束振铃时间，也是被叫摘机时间，等于starttime
    @Column(name = "called_starttime")
    private Date calledStarttime;// 开始时间，被叫摘机时间，如果被叫未接听则为空。
    @Column(name = "called_subId")
    private String calledSubId;// 云通讯平台子帐号
    @Column(name = "called_userData")
    private Integer calledUserData;// 双呼传入参数,代表callservice_info_id
    @Column(name = "caller_appId")
    private String callerAppId;// 应用ID
    @Column(name = "caller_beginCallTime")
    private Date callerBeginCallTime;// 开始呼叫主叫时间
    @Column(name = "caller_byetype")
    private String callerByetype;// 正常挂机
    @Column(name = "caller_callSid")
    private String callerCallSid;// 回拨接口请求后响应返回的callSid参数，一路呼叫的唯一标识。
    @Column(name = "caller_called")
    private String callerCalled;// 机构双呼电话
    @Column(name = "caller_caller")
    private String callerCaller;// 容联中心电话
    @Column(name = "caller_duration")
    private Integer callerDuration;// 主叫接听电话秒数,如果主叫未接听则为0
    @Column(name = "caller_endtime")
    private Date callerEndtime;// 结束时间，主叫挂机时间，如果主叫未接听则为空。
    @Column(name = "caller_lineNumber")
    private String callerLineNumber;// 接口数据
    @Column(name = "caller_lostRate")
    private String callerLostRate;// 接口数据
    @Column(name = "caller_ringingBeginTime")
    private Date callerRingingBeginTime;// 主叫开始振铃时间
    @Column(name = "caller_ringingEndTime")
    private Date callerRingingEndTime;// 主叫结束振铃时间，也是主叫摘机时间，等于starttime
    @Column(name = "caller_starttime")
    private Date callerStarttime;// 开始时间，主叫摘机时间，如果主叫未接听则为空。
    @Column(name = "caller_subId")
    private String callerSubId;// 云通讯平台子帐号
    @Column(name = "caller_userData")
    private Integer callerUserData;// 双呼传入参数,代表callservice_info_id
    @Column(name = "orderid")
    private String orderId;
    @Column(name = "recordurl")
    private String recordUrl;// 通话录音下载地址，当回拨接口中needRecord参数设置录音且主叫摘机才会有下载地址，否则没有此参数。注：因为录音文件需要时间同步到下载服务器，建议在获取到录音下载地址10秒后再进行
}
