/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.callservice.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.callservice.dao.ConsultCallRecordDao;
import com.baijia.tianxiao.dal.callservice.po.ConsultCallRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;

/**
 * @title CallServiceDialBackDaoImpl
 * @desc TODO 
 * @author caoliang
 * @date 2016年5月4日
 * @version 1.0
 */
    
@Repository
public class ConsultCallRecordDaoImpl extends JdbcTemplateDaoSupport<ConsultCallRecord> implements ConsultCallRecordDao {

    /**
     * @param entityClass
     */
    public ConsultCallRecordDaoImpl() {
        super(ConsultCallRecord.class);
    }

	@Override
	public List<ConsultCallRecord> listBy(Long orgId, Long studentId, Long consulterId) {
		SingleSqlBuilder<ConsultCallRecord> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        
        if(consulterId!=null && consulterId>0 && studentId!=null && studentId>0){
        	builder.or(Expressions.eq("consulterId", consulterId), Expressions.eq("orgStudentId", studentId));
        }else{
	        if(consulterId!=null && consulterId>0){
	        	builder.eq("consulterId", consulterId);
	        }
	        if(studentId!=null && studentId>0){
	        	builder.eq("orgStudentId", studentId);
	        }
        }
        
        //builder.gt("callStatus", 0);
        builder.desc("createTime");
        return queryList(builder);
	}

	@Override
	public ConsultCallRecord get(Integer source, Long sourceId) {
		SingleSqlBuilder<ConsultCallRecord> builder = createSqlBuilder();
        builder.eq("source", source);
        builder.eq("sourceId", sourceId);
        return uniqueResult(builder);
	}

	@Override
	public List<ConsultCallRecord> page(PageDto dto) {
		SingleSqlBuilder<ConsultCallRecord> builder = createSqlBuilder();
		builder.setPage(dto);
		return queryList(builder);
	}

}
