
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.dal.callservice.constant;

import com.google.common.collect.Maps;

import java.util.Map;


/**
 * @title RLCallStatus
 * @desc TODO 
 * @author caoliang
 * @date 2016年5月4日
 * @version 1.0
 */

public enum RLCallStatus {
    UNKNOW("0","未知"),
    CANCEL("1","通话中取消回拨、直拨和外呼的正常结束通话"),
    TIME_EXHAUSTED("2","账户欠费或者设置的通话时间到"),
    SUBSCRIBER_HANGUP("3","回拨通话中主叫挂断，正常结束通话"),
    CUSTOMER_HANGUP("4","回拨通话中被叫挂断，正常结束通话"),
    CUSTOMER_HANGUP_BEFORE_RING("-1","被叫没有振铃就收到了挂断消息"),
    CALL_TIME_OUT("-2","呼叫超时没有接通被挂断"),
    SUBSCRIBER_HANGUP_AFTER_RING("-3","回拨主叫接通了主叫挂断"),
    SUBSCRIBER_HANGUP_AFTER_RING1("-4","回拨主叫通道创建了被挂断"),
    CUSTOMER_HANGUP_AFTER_RING("-5","被叫通道建立了被挂断"),
    CUSTOMER_HANGUP_AFTER_RING2("-9","回拨被叫振铃了挂断"),
    SUBSCRIBER_HANGUP_AFTER_RING2("-10","回拨主叫振铃了挂断"),
    MONEY_EXHAUSTED("-11","账户余额不足"),
    INTERFACE_CANCEL("-14","回拨取消呼叫(通过取消回拨接口)"),
    ;
    private static Map<String, String> CONNECTED = Maps.newHashMap();
    private static Map<String, String> LISTENER_UNCONNECT = Maps.newHashMap();
    private static Map<String, String> CALL_UNCONNECT = Maps.newHashMap();

    static{
        CONNECTED.put(CANCEL.code, CallServiceCdrStatus.CONNECTED.getCode().toString());
        CONNECTED.put(SUBSCRIBER_HANGUP.code, CallServiceCdrStatus.CONNECTED.getCode().toString());
        CONNECTED.put(CUSTOMER_HANGUP.code, CallServiceCdrStatus.CONNECTED.getCode().toString());

        LISTENER_UNCONNECT.put(TIME_EXHAUSTED.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(MONEY_EXHAUSTED.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(CALL_TIME_OUT.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(INTERFACE_CANCEL.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(CUSTOMER_HANGUP_AFTER_RING2.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(CUSTOMER_HANGUP_AFTER_RING.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());

        CALL_UNCONNECT.put(SUBSCRIBER_HANGUP_AFTER_RING1.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());
        CALL_UNCONNECT.put(SUBSCRIBER_HANGUP_AFTER_RING2.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());
        CALL_UNCONNECT.put(SUBSCRIBER_HANGUP_AFTER_RING.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());
        CALL_UNCONNECT.put(CUSTOMER_HANGUP_BEFORE_RING.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());

    }

    private String code;
    private String label;
    
    RLCallStatus(String code, String label){
        this.code = code;
        this.label = label;
    }

    public static Integer getCdrStatus(String code) {
        if (code == null) {
            return null;
        }
        if (CONNECTED.containsKey(code)) {
            return Integer.valueOf(CONNECTED.get(code));
        }
        if (LISTENER_UNCONNECT.containsKey(code)) {
            return Integer.valueOf(LISTENER_UNCONNECT.get(code));
        }
        if (CALL_UNCONNECT.containsKey(code)) {
            return Integer.valueOf(CALL_UNCONNECT.get(code));
        }
        return Integer.valueOf(UNKNOW.getCode());
    }

    public String getCode() {

        return code;
    }

    public void setCode(String code) {

        this.code = code;
    }

    public String getLabel() {

        return label;
    }

    public void setLabel(String label) {

        this.label = label;
    }
}

    