package com.baijia.tianxiao.dal.callservice.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @title OrgCallStatus
 * @desc TODO
 * @author shizuwei
 * @date 2015年11月2日
 * @version 1.0
 */

public enum OrgCallStatus {

    // 电话接通状态, 1 接通 2 未接通 3 分机号错误

    CONNECTED(1, "接通"), NOT_CONNECTED(2, "未接通"), EXT_NUMBER_ERROR(3, "分机号错误");

    private Integer code;
    private String msg;

    private OrgCallStatus(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, OrgCallStatus> map = Maps.newHashMap();

    private OrgCallStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    static {
        for (OrgCallStatus at : OrgCallStatus.values()) {
            map.put(at.code, at);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public static OrgCallStatus getTypeByCode(Integer code) {
        return map.get(code);
    }

}
