/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.callservice.constant;

import java.util.Map;

import com.google.common.collect.Maps;

public enum ConsultCallRecordManner {
	CALL(1, "呼出"), ANSWER(2, "呼入");

    private Integer code;
    private String msg;

    private ConsultCallRecordManner(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private static Map<Integer, ConsultCallRecordManner> map = Maps.newHashMap();

    private ConsultCallRecordManner(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    static {
        for (ConsultCallRecordManner at : ConsultCallRecordManner.values()) {
            map.put(at.code, at);
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public static ConsultCallRecordManner getTypeByCode(Integer code) {
        return map.get(code);
    }

}
