
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.blackboard.dao.impl;

import com.baijia.tianxiao.dal.blackboard.dao.OrgBlackboardDao;
import com.baijia.tianxiao.dal.blackboard.po.Blackboard;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @title OrgBlackboardDaoImpl
 * @desc TODO
 * @author zhangbing
 * @date 2015年12月26日
 * @version 1.0
 */
@Repository
public class OrgBlackboardDaoImpl extends JdbcTemplateDaoSupport<Blackboard> implements OrgBlackboardDao {

    public OrgBlackboardDaoImpl() {
        super(Blackboard.class);
    }

    @Override
    public List<Blackboard> getOrgBlackboardList(Long orgId, PageDto pageDto, String...queryProp) {
        SingleSqlBuilder<Blackboard> builder = createSqlBuilder();
        builder.select(queryProp);
        builder.eq("orgId", orgId);
        builder.ne("cType", 9);
        builder.eq("auditstatus", AuditStatus.PASS.getValue());
        builder.eq("isdel", DeleteStatus.NORMAL.getValue());
        builder.desc("createTime");
        builder.setPage(pageDto);
        return queryList(builder);
    }

}
