
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.article.dao.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.article.dao.BisFeedChannelDao;
import com.baijia.tianxiao.dal.article.po.BisFeedChannel;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 10, 2016
 * @desc 查找feed频道表获取指定频道的文章Id
 */
@Service
public class BisFeedChannelDaoImpl extends JdbcTemplateDaoSupport<BisFeedChannel> implements BisFeedChannelDao {

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dal.article.dao.BisFeedChannelDao#listFeedIdsWithPublistTime(java.lang.Long, long,
     * com.baijia.tianxiao.sqlbuilder.dto.PageDto)
     */
    @Override
    public List<BisFeedChannel> listFeedIdsWithPublistTime(Long channelId, long curSyncTime, PageDto page) {
        SingleSqlBuilder<BisFeedChannel> createSqlBuilder = createSqlBuilder("feedId", "publishTime");
        createSqlBuilder.eq("channelId", channelId);
        createSqlBuilder.gt("publishTime", new Date(curSyncTime));
        createSqlBuilder.eq("status", 1);
        createSqlBuilder.eq("type", 1);
        createSqlBuilder.eq("deleteFlag", 0);
        createSqlBuilder.asc("publishTime");
        createSqlBuilder.setPage(page);
        List<BisFeedChannel> queryList = queryList(createSqlBuilder);
        if (GenericsUtils.isNullOrEmpty(queryList)) {
            return Collections.emptyList();
        }
        return queryList;
    }

}
