/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.advisory.dao.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.advisory.dao.OrgStuAdOpRecordDao;
import com.baijia.tianxiao.dal.advisory.po.OrgStuAdOpRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;

/**
 * @title OrgStuAdOpRecordDaoImpl
 * @desc TODO
 * @author cxm
 * @date 2015年9月23日
 * @version 1.0
 */
@Repository
public class OrgStuAdOpRecordDaoImpl extends JdbcTemplateDaoSupport<OrgStuAdOpRecord> implements
    OrgStuAdOpRecordDao {

    /**
     * @param poClass
     */
    public OrgStuAdOpRecordDaoImpl() {
        super(OrgStuAdOpRecord.class);
    }

    @Override
    public List<OrgStuAdOpRecord> query(Collection<Long> advisoryIds) {
        if (CollectionUtils.isEmpty(advisoryIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate<Long, OrgStuAdOpRecord> queryTem = new ListBatchQueryTemplate<>();
        return queryTem.batchQuery(advisoryIds, new BatchQueryCallback<Long, List<OrgStuAdOpRecord>>() {
            @Override
            public List<OrgStuAdOpRecord> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder<OrgStuAdOpRecord> builder = createSqlBuilder();
                builder.in("advisoryId", querySet);
                builder.desc("createTime");
                return queryList(builder);
            }
        });

    }

    @Override
    public List<OrgStuAdOpRecord> query(Long advisoryId) {
        SingleSqlBuilder<OrgStuAdOpRecord> builder = createSqlBuilder();
        builder.eq("advisoryId", advisoryId);
        builder.desc("createTime");
        return queryList(builder);
    }

    @Override
    public List<OrgStuAdOpRecord> query(Long advisoryId, Integer callType) {
        SingleSqlBuilder<OrgStuAdOpRecord> builder = createSqlBuilder();
        builder.eq("advisoryId", advisoryId);
        builder.eq("calType", callType);
        builder.desc("createTime");
        return queryList(builder);
    }

    @Override
    public OrgStuAdOpRecord getRecourdByCallId(Long callId) {
        SingleSqlBuilder<OrgStuAdOpRecord> builder = createSqlBuilder();
        builder.eq("callId", callId);
        return uniqueResult(builder);
    }

}
