/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.advisory.dao;

import com.baijia.tianxiao.dal.advisory.dao.dto.CallStatisticDto;
import com.baijia.tianxiao.dal.advisory.po.OrgCallRecordCount;
import com.baijia.tianxiao.dal.advisory.po.OrgCallRecorder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @title OrgCallRecorderDao
 * @desc TODO
 * @author shanyu
 * @date 2015年11月12日
 * @version 1.0
 */

public interface OrgCallRecorderDao extends CommonDao<OrgCallRecorder> {

    /**
     * @param startTime
     * @param endTime
     * @param extension
     * @param key
     * @param statuses
     * @param page
     * @return
     */
    public List<OrgCallRecorder> query(Date startTime, Date endTime, String extension, String key,
        Collection<Integer> statuses, PageDto page);

    public List<OrgCallRecorder> query(Date startTime, Date endTime, Collection<String> extensions, PageDto page);

    /**
     * 根据订单状态查询订单数量
     * 
     * @param startTime
     * @param endTime
     * @param extensions
     * @param status
     * @param processStatus
     * @return
     */
    public Integer queryCount(Date startTime, Date endTime, Collection<String> extensions, Integer status,
        Integer processStatus);

    /**
     * 统计机构400电话
     */
    OrgCallRecordCount queryOrgCallRecordCount(Date startTime, Date endTime, Collection<String> extensions);

    /**
     * 查询手机号和学生的通话次数
     * 
     * @param mobile
     * @param extension
     * @return
     */
    Map<String, Object> queryCallCountAndTime(String mobile, String extension);
    
    /**
     *统计400电话通话次数和通话时长
     */
    Map<String, CallStatisticDto> getCallStatisticDtoMapByExtensions(Date startTime, Date endTime, Collection<String> extensions);
    
    /**
     * 统计机构400电话接通次数
     * @param startTime
     * @param endTime
     * @param extension
     * @return
     */
    Integer getOrgCallRecordCountByExtexsion(Date startTime, Date endTime, String extension);
    
    /**
     * 统计400电话接通时常
     */
    Integer getOrgCallRecordTimeByExtension(Date startTime, Date endTime, String extension);
    
}
