package com.baijia.tianxiao.dal.advisory.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @title AdvisoryType
 * @desc 学生咨询机构的类型
 * @author cxm
 * @date 2015年9月22日
 * @version 1.0
 */
public enum AdvisoryType {

    TRIAL_COURSE(0, "预约试听", "cdb.org_course"),

    TEL_ADVISORY(1, "来电咨询", "cdb.org_course"),

    CLASS_COURSE_ADVISORY(2, "班课咨询", "cdb.teacher_class_course"),

    ORG_ADVISORY(3, "机构主页", "yunying.org_account"),
    
    TEACHER(4, "老师咨询", "cdb.teacher"),

    TEACHER_COURSE(5, "一对一咨询", "cdb.teacher_course"),
    
    GOLD_ORG_STUDENT_ADVISORY(6, "生源留单", "jigou"),
    ;

    private int code;

    private String note;

    private String table;

    private static Map<Integer, AdvisoryType> map = Maps.newHashMap();

    private static Map<String, AdvisoryType> tableMap = Maps.newHashMap();

    private AdvisoryType(int code, String note) {
        this.code = code;
        this.note = note;
    }

    private AdvisoryType(int code, String note, String table) {
        this.code = code;
        this.note = note;
        this.table = table;
    }

    static {
        for (AdvisoryType at : AdvisoryType.values()) {
            map.put(at.code, at);
            tableMap.put(at.table, at);
        }
    }

    public String getTable() {
        return this.table;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static AdvisoryType getTypeByCode(Integer code) {
        return map.get(code);
    }

    public static AdvisoryType getTypeByCode(String table) {
        return tableMap.get(table);
    }

}
