package com.baijia.tianxiao.dal.activity.po.vote;

import java.sql.Timestamp;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * Created by liuxp on 16/2/20.
 *
 * 投票配置
 */

@Entity
@Data
@Table(name = "tx_activity_vote", catalog = "yunying")
public class VoteInfo {
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long activityId;

    @Column(name = "org_id")
    private Long orgId;

    @Column(name = "name")
    private String name;// 投票名称

    @Column(name = "start_time")
    private Timestamp startTime;// 投票开始时间

    @Column(name = "end_time")
    private Timestamp endTime;// 投票结束时间

    @Column(name = "create_time")
    private Timestamp createTime;

    @Column(name = "update_time")
    private Timestamp updateTime;

    @Column(name = "count_limit")
    private Integer countLimit;

    @Column(name = "col_num")
    private Integer colNum;

    @Column(name = "is_voted_by_day")
    private Integer isVotedByDay;// 投票期间，是否可以每天参与投票

    @Column(name = "top_pic")
    private String topPic; // 头图

    @Column(name = "is_show_top_pic")
    private Integer isShowTopPic;// 是否显示头图

    @Column(name = "content")
    private String content;// 投票详细介绍

    @Column(name = "is_rank_sort")
    private Integer isRankSort;// 是否开启排名排序

    @Column(name = "ad_status")
    private Integer adStatus;

    @Column(name = "slogan")
    private String slogan;

    @Column(name = "ad_url")
    private String adUrl;

    @Column(name = "status")
    private Integer status;

    @Column(name = "template_type_id")
    private Integer templateTypeId;

    @Column(name = "template_id")
    private Integer templateId;

    @Column(name = "is_fold")
    private Integer isFold;// 内容是否折叠

    @Column(name = "info_fill_status")
    private Integer infoFillStatus = 1; // 1.是否需要关注微信公众号 2.是否需要填写手机号码信息 3.两者都需要

    @Column(name = "del_status")
    private Integer delStatus = 0; // 活动是否删除 0未删除 1删除
}
