package com.baijia.tianxiao.dal.activity.po.referral;

import java.sql.Timestamp;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Mar 3, 2016 5:03:48 PM
 * @desc :
 */
@Data
@Entity
@Table(name = "tx_activity_referral_record", catalog = "yunying")
public class ReferralRecord {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;

    @Column(name = "activity_id")
    private Long activityId; // 转介绍活动的id

    @Column(name = "create_time")
    private Timestamp createTime; // 活动创建时间

    @Column(name = "update_time")
    private Timestamp updateTime; // 活动更新时间

    @Column(name = "mark_time")
    private Timestamp markTime; // 标记完成时间

    @Column(name = "account_type")
    private Integer accountType; // 账户类型

    @Column(name = "account_num")
    private String accountNum; // 账户

    @Column(name = "broker_name")
    private String brokerName; // 经纪人姓名

    @Column(name = "broker_phone")
    private String brokerPhone; // 经济人电话

    @Column(name = "referral_name")
    private String referralName; // 被介绍人的名称

    @Column(name = "referral_phone")
    private String referralPhone; // 被介绍人的电话

    @Column(name = "referral_desc")
    private String referralDesc; // 推荐理由

    @Column(name = "gift_id")
    private Long giftId; // 奖品项id

    @Column(name = "introduce_way_desc")
    private String introduceWayDesc; // 介绍方式

    @Column(name = "type")
    private Integer type; // 奖品类型 1:现金 2:非现金

    @Column(name = "gift_desc")
    private String giftDesc; // 奖品信息

    @Column(name = "settlement_status")
    private Integer settlementStatus; // 当前记录的结算状态 1:未结算 2:已结算

}
