package com.baijia.tianxiao.dal.activity.po.referral;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.sql.Timestamp;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 9:56:59 AM
 * @desc : 转介绍活动的PO对象
 */
@Entity
@Data
@Table(name = "tx_activity_referral", catalog = "yunying")
public class ReferralInfo {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long activityId;
    @Column(name = "title")
    private String title;
    @Column(name = "count_limit")
    private Integer countLimit;
    @Column(name = "sub_title")
    private String subTitle;
    @Column(name = "org_id")
    private Long orgId;
    @Column(name = "start_time")
    private Timestamp startTime;
    @Column(name = "end_time")
    private Timestamp endTime;
    @Column(name = "create_time")
    private Timestamp createTime;
    @Column(name = "update_time")
    private Timestamp updateTime;
    @Column(name = "top_pic_url")
    private String topPicUrl;
    @Column(name = "contact")
    private String contact;
    @Column(name = "status")
    private Integer status;
    @Column(name = "template_id")
    private Long templateId;
    @Column(name = "template_type_id")
    private Integer templateTypeId;
    
    @Column(name = "del_status")
    private Integer delStatus = 0;  //是否删除 0未删除，1删除

}
