/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.activity.po.groupclass;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.sql.Timestamp;

import lombok.Data;

/**
 * @title GroupClassInfo
 * @desc 拼班活动的PO对象
 * @author gaodan
 * @date 2016年3月10日
 * @version 1.0
 */
@Entity
@Data
@Table(name = "tx_activity_group_class", catalog = "yunying")
public class GroupClassInfo {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long activityId; // 活动的id
    @Column(name = "org_id")
    private Long orgId; // 机构的id
    @Column(name = "course_name")
    private String courseName; // 课程活动名称
    @Column(name = "count_limit")
    private Integer countLimit; // 课程人数限制
    @Column(name = "original_price")
    private Double originalPrice; // 课程原价
    @Column(name = "teaching_time_desc")
    private String teachingTimeDesc; // 授课时间描述
    @Column(name = "course_type_id")
    private Long courseTypeId; // 课程类型
    @Column(name = "teaching_type")
    private Integer teachingType; // 授课方式：线上或者线下
    @Column(name = "contact")
    private String contact; // 授课地址
    @Column(name = "course_intro")
    private String courseIntro; // 课程简介
    @Column(name = "course_video_url")
    private String courseVideoUrl; // 课程视屏地址
    @Column(name = "course_detail_text")
    private String courseDetailText; // 课程详细
    @Column(name = "start_time")
    private Timestamp startTime; // 活动开始时间
    @Column(name = "end_time")
    private Timestamp endTime; // 活动结束时间
    @Column(name = "create_time")
    private Timestamp createTime; // 活动创建时间
    @Column(name = "update_time")
    private Timestamp updateTime; // 活动更新时间
    @Column(name = "enroll_single_price")
    private Double enrollSinglePrice; // 单人报名价格
    @Column(name = "enroll_multiple_price")
    private Double enrollMultiplePrice; // 拼班每人报名价格
    @Column(name = "enroll_multiple_number")
    private Integer enrollMultipleNumber; // 拼班人数
    @Column(name = "declaration")
    private String declaration; // 公告

}
