package com.baijia.tianxiao.dal.activity.po.draw;

import java.io.Serializable;
import java.math.BigDecimal;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 11:03:32 AM
 * @desc :
 */
@Entity
@Table(name = "tx_draw_prize", catalog = "yunying")
public class PrizeInfo implements Serializable {
    private static final long serialVersionUID = 1140581114553803915L;
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;
    @Column(name = "activity_id")
    private Long activityId; // 抽奖活动Id
    @Column(name = "name")
    private String name; // 奖品名称
    @Column(name = "count_limit")
    private Integer countLimit = 0; // 默认值设置为0,奖品数量
    @Column(name = "url")
    private String url; // 奖品展示图片对应的url
    @Column(name = "probability")
    private BigDecimal probability; // 奖品的抽奖概率 0.0x 代表中奖概率为百分之x ,0.000x 代表中奖概率为万分之x
    @Column(name = "number")
    private Integer number = 0; // 默认值设置为0 , 该奖品每天能中几个
    @Column(name = "win_num")
    private Integer winNum = 0; //已中奖个数
    @Column(name = "grade")
    private Integer grade;// 奖品的等级

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCountLimit() {
        return countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public BigDecimal getProbability() {
        return probability;
    }

    public void setProbability(BigDecimal probability) {
        this.probability = probability;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Integer getWinNum() {
        return winNum;
    }

    public void setWinNum(Integer winNum) {
        this.winNum = winNum;
    }

    @Override
    public String toString() {
        return "PrizeInfo [id=" + id + ", activityId=" + activityId + ", name="
                + name + ", countLimit=" + countLimit +", winNum=" + winNum
                + ", url=" + url + ", probability=" + probability + ", number="
                + number + ", grade=" + grade + "]";
    }

}
