package com.baijia.tianxiao.dal.activity.po.draw;

import java.sql.Timestamp;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 10:46:42 AM
 * @desc : 抽奖活动基本信息
 */
@Entity
@Data
@Table(name = "tx_draw_info", catalog = "yunying")
public class DrawInfo {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long activityId;
    @Column(name = "org_id")
    private Long orgId;
    @Column(name = "name")
    private String name;
    @Column(name = "start_time")
    private Timestamp startTime;
    @Column(name = "end_time")
    private Timestamp endTime;
    @Column(name = "create_time")
    private Timestamp createTime;
    @Column(name = "update_time")
    private Timestamp updateTime;
    @Column(name = "count_limit")
    private Integer countLimit = 0; // 默认值设置为0
    @Column(name = "introduction")
    private String introduction;
    @Column(name = "content")
    private String content;
    @Column(name = "ad_status")
    private Integer adStatus;
    @Column(name = "slogan")
    private String slogan;
    @Column(name = "ad_url")
    private String adUrl;
    @Column(name = "status")
    private Integer status;
    @Column(name = "template_type_id")
    private Integer templateTypeId;
    @Column(name = "template_id")
    private Integer templateId;
    @Column(name = "is_check")
    private Integer isCheck;
    @Column(name = "info_fill_status")
    private Integer infoFillStatus = 1; // 1.是否需要关注微信公众号 2.是否需要填写手机号码信息 3.两者都需要
    @Column(name = "del_status")
    private Integer delStatus = 0; // 活动是否删除 0未删除 1删除
}
