package com.baijia.tianxiao.dal.activity.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * Created by liuxp on 16/4/16.
 */
@Entity
@Data
@Table(name = "tx_marketing_entry", catalog = "yunying")
public class MarketingEntry {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private int id;

    @Column(name="group_id")
    private int groupId;//分组

    @Column(name="event")
    private String event;//事件名

    @Column(name="version")
    private String version;//版本号

    @Column(name="title")
    private String title;//标题

    @Column(name="icon")
    private String icon;//图标

    @Column(name="url")
    private String url;//H5 url

    @Column(name="auth")
    private Integer auth;//认证状态，暂时没起作用

    @Column(name="parent_id")
    private int parentId;//父级入口ID

    @Column(name="sort_num")
    private int sortNum;//排序编号

    @Column(name="visible")
    private int visible;//是否可见

    @Column(name="sys_type")
    private int sysType;//归属系统

    @Column(name="permission_code")
    private Long permissionCode;//对应权限编码
    
    @Column(name = "promotion_icon_url")
    private String promotionIconUrl; //营销入口促销图片url  1.7版本添加
    
    @Column(name = "vip_level")
    private String vipLevel;   //机构显示营销入口促销图片url的类型，1:免费版 2：白金版  用户勾选哪个存哪个  用','隔开
}