package com.baijia.tianxiao.dal.activity.po;

import java.sql.Timestamp;

import com.baijia.tianxiao.dal.activity.constants.CommonConstant;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Jan 9, 2016 5:34:05 PM
 * @desc : 活动的配置信息
 */

@Entity
@Data
@Table(name = "org_blackboard_conf", catalog = "yunying")
public class ActivityConf {

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;
    @Column(name = "blackboard_id")
    private Long activityId; // 活动的id
    @Column(name = "org_id")
    private Integer orgId; // 机构的id
    @Column(name = "start_time")
    private Timestamp startTime; // 活动开始时间
    @Column(name = "end_time")
    private Timestamp endTime; // 活动结束时间
    @Column(name = "count_limit")
    private Integer countLimit; // 报名人数限制
    @Column(name = "display")
    private Integer display; // 隐私设置:是否在机构主页显示 0：显示 1:不显示
    // 报名结束时间
    @Column(name = "report_end_time")
    private Timestamp reportEndTime;
    // 经度
    @Column(name = "longitude")
    private String longitude;
    // 维度
    @Column(name = "latitude")
    private String latitude;
    // 活动地址
    @Column(name = "address")
    private String address;
    // 地域ID，需要app端进行值的传递
    @Column(name = "area_id")
    private Long areaId;
    // 模板id
    @Column(name = "template_id")
    private Integer templateId;
    // 自定义配置信息
    @Column(name = "customize_conf")
    private String customConf;
    // 模板类型id
    @Column(name = "template_type_id")
    private Integer templateTypeId;

}
