package com.baijia.tianxiao.dal.activity.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuxp on 16/2/23.
 */
public enum  ActivityStatus {
    CLOSED(0, "已关闭"),
    UN_START(1, "未开始"),
    RUNNING(2,"进行中"),
    END(3, "已结束");


    public int code;
    public String desc;

    private ActivityStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    
    private static Map<Integer, ActivityStatus> activityStatusMap = new HashMap<>();
    
    static{
        for(ActivityStatus status : ActivityStatus.values()){
            activityStatusMap.put(status.getCode(), status);
        }
    }
    
    public static  ActivityStatus getActivityStatus(int status){
        return activityStatusMap.get(status);
    }
    

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
