package com.baijia.tianxiao.dal.activity.dao.vote.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.activity.dao.vote.VoteOptionDao;
import com.baijia.tianxiao.dal.activity.po.vote.VoteOption;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**
 * Created by liuxp on 16/2/20.
 */
@Repository
public class VoteOptionDaoImpl extends JdbcTemplateDaoSupport<VoteOption> implements VoteOptionDao {

    public VoteOptionDaoImpl() {
        super(VoteOption.class);
    }

    @Override
    public void batchInsertVoteOptions(List<VoteOption> optionList) {
        if (optionList != null && optionList.size() > 0) {
            saveAll(optionList);
        }
    }

    @Override
    public void deleteVoteOptions(Long voteId, List<Long> optionIds) {
        String sql = "update yunying.tx_activity_vote_option set status=0 where activity_id=:voteId";
        Map<String, Object> paraMap = new HashMap<>();
        paraMap.put("voteId", voteId);
        if (optionIds != null && optionIds.size() > 0) {
            sql += " and id not in (:optionIds)";
            paraMap.put("optionIds", optionIds);
        }
        getNamedJdbcTemplate().update(sql, paraMap);
    }

    @Override
    public void updateVoteOption(VoteOption option) {
        update(option);
    }

    @Override
    public List<VoteOption> selectVoteOptionsByVoteId(Long voteId) {
        SingleSqlBuilder sqlBuilder = createSqlBuilder();
        sqlBuilder.eq("activityId", voteId);
        sqlBuilder.eq("status", 1);
        return queryList(sqlBuilder);
    }
}
