package com.baijia.tianxiao.dal.activity.dao.vote.impl;

import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/2/20.
 */
@Repository
public class VoteInfoDaoImpl extends JdbcTemplateDaoSupport<VoteInfo> implements VoteInfoDao {

    public VoteInfoDaoImpl() {
        super(VoteInfo.class);
    }

    @Override
    public Long insertVoteActivity(VoteInfo voteInfo) {
        save(voteInfo);
        return voteInfo.getActivityId();
    }

    @Override
    public void updateVoteActivity(VoteInfo voteInfo) {
        update(voteInfo);
    }

    @Override
    public VoteInfo selectVoteInfo(Long activityId, Long orgId) {
        SingleSqlBuilder<VoteInfo> sqlBuilder = createSqlBuilder();
        sqlBuilder.eq("activityId", activityId);
        if (orgId != null) {
            sqlBuilder.eq("orgId", orgId);
        }
        sqlBuilder.eq("delStatus", 0);
        List<VoteInfo> queryList = queryList(sqlBuilder);
        if (GenericsUtils.notNullAndEmpty(queryList)) {
            return queryList.get(0);
        } else {
            return null;
        }
    }

    @Override
    public VoteInfo selectVoteInfo(Long activityId, Long orgId, Integer delStatus) {
        SingleSqlBuilder<VoteInfo> sqlBuilder = createSqlBuilder();
        sqlBuilder.eq("activityId", activityId);
        if (orgId != null) {
            sqlBuilder.eq("orgId", orgId);
        }
        if (delStatus != null) {
            sqlBuilder.eq("delStatus", delStatus);
        }
        List<VoteInfo> queryList = queryList(sqlBuilder);
        if (GenericsUtils.notNullAndEmpty(queryList)) {
            return queryList.get(0);
        } else {
            return null;
        }
    }

    @Override
    public List<VoteInfo> selectVoteInfoList(Integer status, Long orgId, PageInfo pageInfo) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", pageInfo.getLastId());
        paramMap.put("orgId", orgId);
        String timeCondition = "";
        if (status == ActivityStatus.CLOSED.getCode()) {
            paramMap.put("status", status);// 关闭
        } else {
            paramMap.put("status", 1);// 打开
            paramMap.put("curDate", new Date());
            if (ActivityStatus.UN_START.getCode() == status) {
                timeCondition = " and start_time > :curDate ";
            } else if (ActivityStatus.END.getCode() == status) {
                timeCondition = " and end_time <= :curDate ";
            } else {
                timeCondition = " and start_time <= :curDate and end_time>:curDate ";
            }
        }

        paramMap.put("firstIndex", (pageInfo.getPageDto().getPageNum() - 1) * pageInfo.getPageDto().getPageSize());
        paramMap.put("pageSize", pageInfo.getPageDto().getPageSize());

        String sql = "select * from yunying.tx_activity_vote o1,"
            + " (select update_time from yunying.tx_activity_vote where id = :id) o2 "
            + " where status = :status and del_status = 0 AND o1.org_id =:orgId  and (o1.update_time < o2.update_time or (o1.update_time = o2.update_time and o1.id < :id)) "
            + timeCondition + " order by o1.update_time desc,o1.id desc limit :firstIndex,:pageSize";

        if (pageInfo.getLastId() == null || pageInfo.getLastId() == 0) {
            sql =
                "select * from yunying.tx_activity_vote where status = :status and del_status = 0 and org_id = :orgId "
                    + timeCondition + "order by update_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        }

        return this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<VoteInfo>>() {

            @Override
            public List<VoteInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<VoteInfo> activitys = new ArrayList<>();
                while (rs.next()) {
                    activitys.add(toActivity(rs));
                }
                return activitys;
            }
        });
    }

    private VoteInfo toActivity(ResultSet rs) throws SQLException {
        VoteInfo activity = new VoteInfo();
        activity.setActivityId(rs.getLong("id"));
        activity.setContent(rs.getString("content"));
        activity.setName(rs.getString("name"));
        activity.setCreateTime(rs.getTimestamp("create_time"));
        activity.setUpdateTime(rs.getTimestamp("update_time"));
        activity.setStartTime(rs.getTimestamp("start_time"));
        activity.setEndTime(rs.getTimestamp("end_time"));
        activity.setOrgId(rs.getLong("org_id"));
        activity.setColNum(rs.getInt("col_num"));
        activity.setIsRankSort(rs.getInt("is_rank_sort"));
        activity.setIsShowTopPic(rs.getInt("is_show_top_pic"));
        activity.setIsVotedByDay(rs.getInt("is_voted_by_day"));
        activity.setTopPic(rs.getString("top_pic"));
        activity.setStatus(rs.getInt("status"));
        activity.setAdStatus(rs.getInt("ad_status"));
        activity.setAdUrl(rs.getString("ad_url"));
        activity.setSlogan(rs.getString("slogan"));
        activity.setCountLimit(rs.getInt("count_limit"));
        activity.setTemplateId(rs.getInt("template_id"));
        activity.setTemplateTypeId(rs.getInt("template_type_id"));
        activity.setDelStatus(rs.getInt("del_status"));
        activity.setInfoFillStatus(rs.getInt("info_fill_status"));
        return activity;
    }

    @Override
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id from yunying.tx_activity_vote where org_id in (:orgIds) group by org_id";

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<List<Long>>() {

            @Override
            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<Long> orgIds = new ArrayList<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    orgIds.add(orgId);
                }
                return orgIds;
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getVoteActivityIdsByOrgIds(List<Long> orgIds, Date startTime, Date endTime) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", orgIds);
        String sql = "select org_id, id from yunying.tx_activity_vote where org_id in (:orgIds)";
        if (startTime != null) {
            sql += " and create_time between :startTime and :endTime ";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, List<Long>>>() {

            @Override
            public Map<Long, List<Long>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, List<Long>> map = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Long activityId = rs.getLong("id");
                    if (map.containsKey(orgId)) {
                        List<Long> activityIds = map.get(orgId);
                        activityIds.add(activityId);
                    } else {
                        List<Long> activityIds = new ArrayList<>();
                        activityIds.add(activityId);
                        map.put(orgId, activityIds);
                    }
                }
                return map;
            }
        });
    }

    @Override
    public List<VoteInfo> selectCurrentVoteList(long orgId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("orgId", orgId);
        paramMap.put("status", 1);
        paramMap.put("currentTime", new Date());
        String sql = "select * from yunying.tx_activity_vote where org_id = :orgId and end_time >= :currentTime";
        return this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<VoteInfo>>() {

            @Override
            public List<VoteInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<VoteInfo> activitys = new ArrayList<>();
                while (rs.next()) {
                    activitys.add(toActivity(rs));
                }
                return activitys;
            }
        });

    }

}
