package com.baijia.tianxiao.dal.activity.dao.referral.impl;

import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 10:05:44 AM
 * @desc :
 */
@Repository
public class ReferralDaoImpl extends JdbcTemplateDaoSupport<ReferralInfo> implements ReferralInfoDao {

    public ReferralDaoImpl() {
        super(ReferralInfo.class);
    }

    @Override
    public Long saveReferral(ReferralInfo ri) {
        save(ri);
        return ri.getActivityId();
    }

    @Override
    public void updateReferral(ReferralInfo ri) {
        Map<String, Object> updateCondtion = new HashMap<>();
        updateCondtion.put("orgId", ri.getOrgId());
        updateCondtion.put("activityId", ri.getActivityId());
        super.update(updateCondtion, ri);
    }

    @Override
    public ReferralInfo getReferralInfo(Long activityId, Long orgId) {
        return this.getReferralInfo(activityId, orgId, DeleteStatus.NORMAL.getValue());
    }

    @Override
    public ReferralInfo getReferralInfo(Long activityId, Long orgId, Integer delStatus) {
        SingleSqlBuilder<ReferralInfo> sqlBuilder = createSqlBuilder();
        sqlBuilder.eq("activityId", activityId);
        if (orgId != null) {
            sqlBuilder.eq("orgId", orgId);
        }
        if (delStatus != null) {
            sqlBuilder.eq("delStatus", delStatus);
        }
        List<ReferralInfo> queryList = queryList(sqlBuilder);
        if (GenericsUtils.notNullAndEmpty(queryList)) {
            return queryList.get(0);
        } else {
            return null;
        }
    }

    @Override
    public List<ReferralInfo> listReferrals(Integer status, Long orgId, PageInfo pageInfo) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", pageInfo.getLastId());
        paramMap.put("orgId", orgId);
        String timeCondition = "";
        if (status == ActivityStatus.CLOSED.getCode()) {
            paramMap.put("status", status);// 关闭
        } else {
            paramMap.put("status", 1);// 打开
            paramMap.put("curDate", new Date());
            if (ActivityStatus.UN_START.getCode() == status) {
                timeCondition = " and start_time > :curDate ";
            } else if (ActivityStatus.END.getCode() == status) {
                timeCondition = " and end_time <= :curDate ";
            } else {
                timeCondition = " and start_time <= :curDate and end_time>:curDate ";
            }
        }

        paramMap.put("firstIndex", (pageInfo.getPageDto().getPageNum() - 1) * pageInfo.getPageDto().getPageSize());
        paramMap.put("pageSize", pageInfo.getPageDto().getPageSize());

        String sql = null;

        if (pageInfo.getLastId() == null || pageInfo.getLastId() == 0) {
            sql =
                "select * from yunying.tx_activity_referral where status = :status and org_id = :orgId and del_status = 0 "
                    + timeCondition + "order by update_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        } else {
            sql = "select * from yunying.tx_activity_referral o1,"
                + " (select update_time from yunying.tx_activity_referral where id = :id) o2 "
                + " where status = :status and del_status = 0 AND o1.org_id =:orgId  and (o1.update_time < o2.update_time or (o1.update_time = o2.update_time and o1.id < :id)) "
                + timeCondition + " order by o1.update_time desc,o1.id desc limit :firstIndex,:pageSize";
        }

        return this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<ReferralInfo>>() {

            @Override
            public List<ReferralInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<ReferralInfo> activitys = new ArrayList<>();
                while (rs.next()) {
                    activitys.add(toActivity(rs));
                }
                return activitys;
            }
        });
    }

    @Override
    public List<ReferralInfo> selectCurrentReferralList(long orgId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("orgId", orgId);
        paramMap.put("status", 1);
        paramMap.put("currentTime", new Date());
        String sql = "select * from yunying.tx_activity_referral where org_id = :orgId and end_time >= :currentTime";
        return this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<ReferralInfo>>() {

            @Override
            public List<ReferralInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<ReferralInfo> activitys = new ArrayList<>();
                while (rs.next()) {
                    activitys.add(toActivity(rs));
                }
                return activitys;
            }
        });
    }

    private ReferralInfo toActivity(ResultSet rs) throws SQLException {
        ReferralInfo activity = new ReferralInfo();
        activity.setActivityId(rs.getLong("id"));
        activity.setTitle(rs.getString("title"));
        activity.setSubTitle(rs.getString("sub_title"));
        activity.setCreateTime(rs.getTimestamp("create_time"));
        activity.setUpdateTime(rs.getTimestamp("update_time"));
        activity.setStartTime(rs.getTimestamp("start_time"));
        activity.setEndTime(rs.getTimestamp("end_time"));
        activity.setOrgId(rs.getLong("org_id"));
        activity.setStatus(rs.getInt("status"));
        activity.setCountLimit(rs.getInt("count_limit"));
        activity.setTemplateId(rs.getLong("template_id"));
        return activity;
    }

    @Override
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id from yunying.tx_activity_referral where org_id in (:orgIds) group by org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<List<Long>>() {

            @Override
            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<Long> orgIds = new ArrayList<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    orgIds.add(orgId);
                }
                return orgIds;
            }
        });
    }

    @Override
    public Map<Long, List<Long>> getReferralActivityIdsByOrgIds(List<Long> orgIds, Date startTime, Date endTime) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", orgIds);
        String sql = "select org_id, id from yunying.tx_activity_referral where org_id in (:orgIds)";
        if (startTime != null && endTime != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("endDate", endTime);
            param.put("startDate", startTime);
        }

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, List<Long>>>() {

            @Override
            public Map<Long, List<Long>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, List<Long>> map = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Long activityId = rs.getLong("id");
                    if (map.containsKey(orgId)) {
                        List<Long> activityIds = map.get(orgId);
                        activityIds.add(activityId);
                    } else {
                        List<Long> activityIds = new ArrayList<>();
                        activityIds.add(activityId);
                        map.put(orgId, activityIds);
                    }
                }
                return map;
            }
        });
    }

}
