package com.baijia.tianxiao.dal.activity.dao.referral;

import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 10:05:29 AM
 * @desc :
 */
public interface ReferralInfoDao extends CommonDao<ReferralInfo>{

    /**
     * 存储一个活动
     */
    public Long saveReferral(ReferralInfo ri);

    /**
     * 修改一个活动
     */
    public void updateReferral(ReferralInfo ri);

    /**
     * 获取一个活动
     */
    public ReferralInfo getReferralInfo(Long activityId, Long orgId);

    /**
     * 获取一批转介绍活动
     */
    public List<ReferralInfo> listReferrals(Integer status, Long orgId, PageInfo pageInfo);

    /**
     * 获取所有参加转介绍活动的机构id
     */
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds);

    /**
     * 获取某机构在某阶段内转介绍活动数
     */
    public Map<Long, List<Long>> getReferralActivityIdsByOrgIds(List<Long> orgIds, Date startTime, Date endTime);

    public List<ReferralInfo> selectCurrentReferralList(long orgId);

    ReferralInfo getReferralInfo(Long activityId, Long orgId, Integer delStatus);

}
