/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.enums.BlackBoardType;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * @author gaodan
 * @createdate 2016年8月22日
 * @desc
 */
@Repository
public class TxActivityCommonDaoImpl extends JdbcTemplateDaoSupport<TxActivityCommon> implements TxActivityCommonDao{

    @Override
    public List<TxActivityCommon> getTxActivityList(Long orgId, Collection<Integer> typeIds, PageDto pageDto,
        Integer isSortedByPopular, Integer status) {
        Date curTime = new Date();
        SingleSqlBuilder<TxActivityCommon> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        
        builder.in("templateTypeId", typeIds);
        //根据活动状态进行筛选
        if(status != null){
            if(status == ActivityStatus.CLOSED.getCode()){
                builder.eq("status", status);
            }else{
                builder.eq("status", 1);   //活动处于开启状态
                if(status == ActivityStatus.UN_START.getCode()){
                    builder.gt("startTime", curTime);
                }else if(status == ActivityStatus.END.getCode()){
                    builder.lt("endTime", curTime);
                }else{
                    builder.le("startTime", curTime);
                    builder.ge("endTime", curTime);
                }
            }
        }
        
        builder.eq("delStatus", DeleteStatus.NORMAL.getValue());
        
        //按照人气或者更新时间进行倒序排序，默认按照更新时间进行排序
        if(isSortedByPopular != null && isSortedByPopular == 1){
            builder.desc("accessCount");
        }else{
            builder.desc("updateTime");
        }
        
        if(pageDto != null){
            builder.setPage(pageDto);
        }
        
        return queryList(builder);
    }

    @Override
    public TxActivityCommon getTxActivityCommon(Long orgId, Integer typeId, Long activityId) {
        SingleSqlBuilder<TxActivityCommon> builder = createSqlBuilder();
        if(orgId != null){
            builder.eq("orgId", orgId);
        }
        builder.eq("activityId", activityId);
        builder.eq("templateTypeId", typeId);
        return uniqueResult(builder);
    }

    @Override
    public Integer getActivityTotal(Long orgId) {
        SingleSqlBuilder<TxActivityCommon> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("delStatus", DeleteStatus.NORMAL.getValue());
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxActivityCommon> selectUnEndedActivityList(long orgId) {
        SingleSqlBuilder<TxActivityCommon> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("delStatus", DeleteStatus.NORMAL.getValue());
        builder.gt("endTime", new Date());
        builder.setOrder(Order.desc("createTime"));
        return queryList(builder);
    }
}
