package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/1/8.
 */
@Repository
public class TemplateDaoImpl extends JdbcTemplateDaoSupport<Template> implements TemplateDao {

    private static final Logger logger = LoggerFactory.getLogger(TemplateDaoImpl.class);

    public TemplateDaoImpl() {
        super(Template.class);
    }

    @Override
    public List<Template> selectTemplateListByTypeId(Collection<Integer> typeIds,PageInfo page) {
        SingleSqlBuilder<Template> builder = createSqlBuilder();
        if(typeIds!=null && typeIds.size()>0) {
            builder.in("typeId", typeIds);
        }
        builder.setPage(page.getPageDto());
        builder.gt("id",page.getLastId());
        return queryList(builder);
    }
    
    @Override
    public List<Template> getTemplateListByCondition(Collection<Integer> typeIds,PageDto pageDto, 
        Integer isSortedByPopular){
        SingleSqlBuilder<Template> builder = createSqlBuilder();
        if(typeIds!=null && typeIds.size()>0) {
            builder.in("typeId", typeIds);
        }
        if(isSortedByPopular != null && isSortedByPopular == 1){
            builder.desc("amountOfUsage");
        }else{
            builder.desc("createTime");
        }
        //按照分页进行列表获取，否则获取全部
        if(pageDto != null){
            builder.setPage(pageDto);
        }
        return queryList(builder);
    }

    @Override
    public void updateTemplateUseCount(Long templateId) {
        String sql = "update yunying.tx_activity_template set amount_of_usage = amount_of_usage+1 where id=:templateId";
        Map<String,Object> param = new HashMap<>();
        param.put("templateId",templateId);
        getNamedJdbcTemplate().update(sql,param);
    }

    @Override
    public Template selectTemplateById(Integer templateId) {
        return getById(templateId);
    }

    @Override
    public List<Template> selectTemplateList() {
        SingleSqlBuilder<Template> builder = createSqlBuilder();
        return queryList(builder);
    }
}
