package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.EnrollDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.ActivityEnroll;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Created by liuxp on 16/1/11.
 */
@Repository
public class EnrollDaoImpl extends JdbcTemplateDaoSupport<ActivityEnroll> implements EnrollDao {

    private static final Logger logger = LoggerFactory.getLogger(EnrollDaoImpl.class);

    public EnrollDaoImpl() {
        super(ActivityEnroll.class);
    }

    @Override
    public List<ActivityEnroll> selectEnrollsByActivityId(long activityId, PageInfo page) {
        SingleSqlBuilder<ActivityEnroll> builder = createSqlBuilder();
        builder.eq("activityId", activityId);
        builder.eq("status", DeleteStatus.NORMAL.getValue());
        if (page != null) {
            if (page.getLastId() != null && page.getLastId() > 0) {
                builder.lt("id", page.getLastId());
            }
            builder.setPage(page.getPageDto());
        }

        builder.desc("id");
        return queryList(builder);
    }

    @Override
    public void insertEnroll(ActivityEnroll enroll) {
        save(enroll);
    }

    @Override
    public int getEnrollCount(long activityId) {
        SingleSqlBuilder<ActivityEnroll> builder = createSqlBuilder();
        builder.eq("activityId", activityId);
        builder.count("id");
        builder.eq("status", DeleteStatus.NORMAL.getValue());
        return queryForObject(builder, Integer.class);
    }

    public ActivityEnroll selectEnrollByMobile(long activityId, String mobile) {
        if (NumberUtils.isDigits(mobile)) {
            SingleSqlBuilder<ActivityEnroll> builder = createSqlBuilder();
            builder.eq("activityId", activityId);
            builder.like("content", "\"mobile\":\"" + mobile + "\"", MatchMode.ANYWHERE);
            List<ActivityEnroll> enrolls = queryList(builder);
            if (enrolls != null && enrolls.size() > 0) {
                return enrolls.get(0);
            }
        } else {
            logger.warn("[ActivityEnroll] mobile=" + mobile);
            throw new RuntimeException("手机号格式错误");
        }

        return null;
    }

    @Override
    public Integer getEnrollTotal(List<Long> activityIds, Date startDate, Date endDate) {
        SingleSqlBuilder<ActivityEnroll> builder = createSqlBuilder();
        builder.in("activityId", activityIds);
        builder.eq("status", DeleteStatus.NORMAL.getValue());
        if (startDate != null) {
            builder.between("createTime", startDate, endDate);
        }
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }
}
