package com.baijia.tianxiao.dal.activity.dao.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.activity.dao.ActivityWechatFilterDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityWechatReplaceDao;
import com.baijia.tianxiao.dal.activity.po.ActivityWechatReplace;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Jul 8, 2016 1:49:57 AM
 * @desc :
 */
@Slf4j
@Repository
public class ActivityWechatFilterDaoImpl implements ActivityWechatFilterDao {

    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private ActivityWechatReplaceDao activityWechatFilterDaoImpl;

    @Override
    public boolean needFilter(String userName) {
    	if(userName.equals("gh_544318566b52")){
    		return false;
    	}
        boolean needFilter = false;
        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByUserName(userName);
        log.info("find authorizerInfo is : {} ", authorizerInfo);
        if (authorizerInfo != null) {
            Integer orgId = authorizerInfo.getOrgId();
            ActivityWechatReplace findByOReplaceOrgId = this.activityWechatFilterDaoImpl.findByOriginOrgId(orgId);
            log.info("find findByOReplaceOrgId is : {} ", findByOReplaceOrgId);
            if (findByOReplaceOrgId != null && findByOReplaceOrgId.getReplaceOrgId() != null
                && findByOReplaceOrgId.getNeedFilterSubscribe() == 0) {
                needFilter = true;
            }
        }
        return needFilter;
    }

}
