package com.baijia.tianxiao.dal.activity.dao.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.enums.BlackBoardType;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Jan 11, 2016 10:22:34 AM
 * @desc :
 */
@Repository
public class ActivityDaoImpl extends JdbcTemplateDaoSupport<Activity> implements ActivityDao {

    private static final Logger logger = LoggerFactory.getLogger(ActivityDaoImpl.class);

    public ActivityDaoImpl() {
        super(Activity.class);
    }

    /**
     * 我需要获取到自动生成的主键的id
     */
    @Override
    public Long saveActivity(final Activity activity) {
        save(activity);
        return activity.getId();
    }

    @Override
    public Activity getActivityById(Long id) {
        if (id == null) {
            return null;
        }
        SingleSqlBuilder<Activity> createSqlBuilder = createSqlBuilder();
        createSqlBuilder.eq("id", id);
        List<Activity> queryList = queryList(createSqlBuilder);
        if (GenericsUtils.notNullAndEmpty(queryList)) {
            return queryList.get(0);
        } else {
            return null;
        }
    }

    @Override
    public void update(Activity activity) {
        super.update(activity);
    }

    @Override
    public List<Activity> listActivities(Integer status, Long lastId, Integer orgId, PageDto pageDto) {

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", lastId);
        paramMap.put("orgId", orgId);
        paramMap.put("firstIndex", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
        paramMap.put("pageSize", pageDto.getPageSize());
        paramMap.put("bType", BlackBoardType.NOTICE.getType());
        paramMap.put("cType", 9);

        String sql = "select * from yunying.org_blackboard_info o1,"
            + " (select update_time from yunying.org_blackboard_info where id = :id) o2 "
            + " where isdel = 0 and bb_type = :bType and c_type=:cType and o1.org_id =:orgId  and (o1.update_time < o2.update_time or (o1.update_time = o2.update_time and o1.id < :id)) "
            + " order by o1.update_time desc,o1.id desc limit :firstIndex,:pageSize";

        if (lastId == null || lastId == 0) {
            sql =
                "select * from yunying.org_blackboard_info where isdel = 0 and  bb_type = :bType and c_type=:cType and org_id = :orgId order by update_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        }

        return this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<Activity>>() {

            @Override
            public List<Activity> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<Activity> activitys = new ArrayList<>();
                while (rs.next()) {
                    activitys.add(toActivity(rs));
                }
                return activitys;
            }
        });
    }

    private Activity toActivity(ResultSet rs) throws SQLException {
        Activity activity = new Activity();
        activity.setId(rs.getLong("id"));
        activity.setContent(rs.getString("content"));
        activity.setBbType(rs.getInt("bb_type"));
        activity.setCreateTime(rs.getString("create_time"));
        activity.setcType(rs.getInt("c_type"));
        activity.setTitle(rs.getString("title"));
        activity.setUpdateTime(rs.getString("update_time"));
        activity.setOrgId(rs.getInt("org_id"));
        activity.setSwitcher(rs.getInt("switcher"));
        activity.setSupportNum(rs.getInt("support_num"));
        activity.setQrUrl(rs.getString("qr_url"));
        activity.setIsdel(rs.getInt("isdel"));
        activity.setrType(rs.getInt("r_type"));
        return activity;
    }

    @Override
    public Activity getActivityByIdAndOrgId(Long id, Long orgId) {
        return this.getActivityByIdAndOrgId(id, orgId, DeleteStatus.NORMAL.getValue());
    }

    @Override
    public Activity getActivityByIdAndOrgId(Long id, Long orgId, Integer isDel) {
        if (id == null) {
            return null;
        }
        SingleSqlBuilder<Activity> builder = createSqlBuilder();
        builder.eq("id", id);
        builder.eq("c_type", 9);

        if (isDel != null) {
            builder.eq("isdel", isDel);
        }
        builder.eq("bb_type", BlackBoardType.NOTICE.getType());
        if (orgId != null) {
            builder.eq("orgId", orgId);
        }
        return uniqueResult(builder);
    }

    @Override
    public Map<Long, List<Long>> getActivityIdByOrgIds(List<Long> orgIds, Date startTime, Date endTime) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", orgIds);
        String sql = "select org_id, id from yunying.org_blackboard_info where c_type = 9 and bb_type = "
            + BlackBoardType.NOTICE.getType() + " and org_id in (:orgIds)";
        if (startTime != null) {
            sql += " and create_time between :startTime and :endTime and org_id in (:orgIds)";
            param.put("startTime", startTime);
            param.put("endTime", endTime);
        }
        return getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, List<Long>>>() {

            @Override
            public Map<Long, List<Long>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, List<Long>> map = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Long activityId = rs.getLong("id");
                    if (map.containsKey(orgId)) {
                        List<Long> activityIds = map.get(orgId);
                        activityIds.add(activityId);
                    } else {
                        List<Long> activityIds = new ArrayList<>();
                        activityIds.add(activityId);
                        map.put(orgId, activityIds);
                    }
                }
                return map;
            }

        });

    }

    @Override
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id from yunying.org_blackboard_info where c_type = 9 " + "and bb_type = "
            + BlackBoardType.NOTICE.getType() + " and org_id in (:orgIds) group by org_id";
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<List<Long>>() {

            @Override
            public List<Long> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<Long> orgIds = new ArrayList<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    orgIds.add(orgId);
                }
                return orgIds;
            }

        });
    }

    @Override
    public Map<Long, Integer> getActivityCount(List<Long> orgIds, Date startDate, Date endDate) {

        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", orgIds);

        String sql = "select org_id, count(org_id) count from yunying.org_blackboard_info where c_type = 9 "
            + "and bb_type = " + BlackBoardType.NOTICE.getType() + " and org_id in :orgIds";
        if (startDate != null && endDate != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> activityCountOfOrgIds = new HashMap<>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    activityCountOfOrgIds.put(orgId, count);
                }
                return activityCountOfOrgIds;
            }

        });
    }

    @Override
    public List<Activity> selectCurrentActivityList(long orgId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("orgId", orgId);
        paramMap.put("bType", BlackBoardType.NOTICE.getType());
        paramMap.put("cType", 9);
        paramMap.put("currentTime", new Date());
        String sql =
            "select * from yunying.org_blackboard_info info left join yunying.org_blackboard_conf conf on info.id = conf.blackboard_id"
                + " where info.org_id = :orgId and bb_type = :bType and c_type=:cType and end_time >= :currentTime";
        return this.getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<Activity>>() {
            @Override
            public List<Activity> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<Activity> activities = new ArrayList<>();
                while (rs.next()) {
                    activities.add(toActivity(rs));
                }
                return activities;
            }
        });
    }

    @Override
    public List<Activity> getActivityList(PageDto pageDto) {
        SingleSqlBuilder<Activity> builder = createSqlBuilder();
        builder.eq("bbType", BlackBoardType.NOTICE.getType());
        builder.eq("cType", 9);
        builder.setPage(pageDto);
        builder.desc("id");
        return queryList(builder);
    }
}
