package com.baijia.tianxiao.dal.activity.dao.impl;

import java.util.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Jan 11, 2016 1:00:23 PM
 * @desc :
 */
@Repository
public class ActivityConfDaoImpl extends JdbcTemplateDaoSupport<ActivityConf> implements ActivityConfDao {

    private static final Logger logger = LoggerFactory.getLogger(ActivityConfDaoImpl.class);

    public ActivityConfDaoImpl() {
        super(ActivityConf.class);
    }

    @Override
    public Map<Long, ActivityConf> getConfigMapByActivityIds(Collection<Long> activityIds) {
        if (GenericsUtils.isNullOrEmpty(activityIds)) {
            return Collections.emptyMap();
        }
        Map<Long, ActivityConf> retMap = new HashMap<>();
        SingleSqlBuilder<ActivityConf> sb = this.createSqlBuilder();
        sb.in("activityId", activityIds);
        List<ActivityConf> queryList = queryList(sb);
        if (queryList != null && queryList.size() > 0) {
            for (ActivityConf conf : queryList) {
                retMap.put(conf.getActivityId(), conf);
            }
        }
        return retMap;
    }

    @Override
    public void saveActivityConf(ActivityConf activityConfig) {
        super.save(activityConfig);
    }

    @Override
    public void updateActivityConf(ActivityConf activityConf) {
        super.update(activityConf);
    }

    @Override
    public ActivityConf getConfigByActivityId(long activityId) {
        Map<Long, ActivityConf> map = getConfigMapByActivityIds(Arrays.asList(activityId));
        if(map!=null && map.get(activityId)!=null){
            return map.get(activityId);
        }
        return null;
    }
}
