package com.baijia.tianxiao.dal.activity.dao.draw.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/1/26.
 */
@Repository
public class WinnerDaoImpl extends JdbcTemplateDaoSupport<Winner> implements WinnerDao {

    public WinnerDaoImpl() {
        super(Winner.class);
    }

    @Override
    public Long insertWinner(Winner winner) {
        save(winner);
        return winner.getDrawId();
    }

    @Override
    public List<Winner> selectWinnerListByPage(long activityId, PageInfo page) {
        SingleSqlBuilder<Winner> builder = createSqlBuilder();
        builder.eq("activityId", activityId);

        if (page != null) {
            if (page.getLastId() != null && page.getLastId() > 0) {
                builder.lt("id", page.getLastId());
            }
            builder.setPage(page.getPageDto());
        }

        builder.desc("createTime");
        return queryList(builder);
    }

    @Override
    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds) {
        String sql =
            "select activity_id,count(id) as count from yunying.tx_activity_winner where activity_id in (:activityIds) group by activity_id";
        Map<String, Object> param = new HashMap<>();
        param.put("activityIds", activityIds);
        return getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Long, Integer>>() {

            @Override
            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    map.put(rs.getLong("activity_id"), rs.getInt("count"));
                }
                return map;
            }
        });
    }

    @Override
    public void updateCheckInInfo(Winner winner) {
        String sql = "update yunying.tx_activity_winner set name = :name,mobile=:mobile,address=:address,"
            + "check_in_time=:checkInTime where id=:id";
        Map<String, Object> param = new HashMap<>();
        param.put("name", winner.getName());
        param.put("mobile", winner.getMobile());
        param.put("address", winner.getAddress());
        param.put("checkInTime", new Date());
        param.put("id", winner.getDrawId());
        getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public Winner selectWinnerById(Long drawId) {
        return getById(drawId);
    }

    @Override
    public Map<Integer, Integer> selectPrizesByDate(long activityId, Date startTime, Date endTime) {
        String sql =
            "select grade,count(id) as count from yunying.tx_activity_winner where activity_id = :activityId and create_time between :startTime"
                + " and :endTime group by grade";
        Map<String, Object> param = new HashMap<>();
        param.put("activityId", activityId);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        return getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<Integer, Integer>>() {

            @Override
            public Map<Integer, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<Integer, Integer> retMap = new HashMap<Integer, Integer>();
                while (rs.next()) {
                    retMap.put(rs.getInt("grade"), rs.getInt("count"));
                }
                return retMap;
            }
        });
    }

    @Override
    public Integer getWinnerTotal(List<Long> activityIds, Date startDate, Date endDate) {
        SingleSqlBuilder<Winner> builder = createSqlBuilder();
        builder.in("activityId", activityIds);
        if (startDate != null) {
            builder.between("createTime", startDate, endDate);
        }
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }
}
