package com.baijia.tianxiao.dal.activity.dao.draw.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.activity.dao.draw.PrizeInfoDao;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 5:18:08 PM
 * @desc :
 */
@Repository
public class PrizeInfoDaoImpl extends JdbcTemplateDaoSupport<PrizeInfo> implements PrizeInfoDao {

    public PrizeInfoDaoImpl() {
        super(PrizeInfo.class);
    }

    @Override
    public void batchAddPrizeInfos(List<PrizeInfo> prizeInfos) {
        super.saveAll(prizeInfos);
    }

    @Override
    public List<PrizeInfo> getPrizeInfosByActivityId(Long activityId) {
        if (activityId == null) {
            return null;
        }
        SingleSqlBuilder<PrizeInfo> createSqlBuilder = createSqlBuilder();
        createSqlBuilder.eq("activityId", activityId);
        List<PrizeInfo> queryList = queryList(createSqlBuilder);
        return queryList;
    }

    @Override
    public void deletePrizesByActivityId(Long activityId) {
        SingleSqlBuilder<PrizeInfo> builder = createSqlBuilder();
        builder.eq("activityId", activityId);
        super.delete(builder);
    }

    @Override
    public PrizeInfo getPrizeInfosById(Long drawId) {
        return super.getById(drawId);
    }

    @Override
    public PrizeInfo getPrizeByCondition(Long activityId, int grade) {
        SingleSqlBuilder<PrizeInfo> builder = createSqlBuilder();
        builder.eq("activityId", activityId);
        builder.eq("grade", grade);
        List<PrizeInfo> queryList = queryList(builder);
        if (GenericsUtils.notNullAndEmpty(queryList)) {
            return queryList.get(0);
        } else {
            return null;
        }
    }

    @Override
    public int updateWinNum(long id) {
        String sql = "update yunying.tx_draw_prize set win_num = win_num+1 where id = :prizeId and count_limit>win_num";
        Map<String,Object> param = new HashMap<>();
        param.put("prizeId",id);
        return getNamedJdbcTemplate().update(sql,param);
    }
}
