package com.baijia.tianxiao.dal.activity.dao.draw;

import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/1/26.
 */
public interface WinnerDao {
    /**
     * 新增获奖用户
     *
     * @param winner
     * @return
     */
    public Long insertWinner(Winner winner);

    /**
     * 根据活动id获取活动获奖用户列表
     *
     * @param activityId
     * @param page
     * @return
     */
    public List<Winner> selectWinnerListByPage(long activityId,PageInfo page);

    /**
     * 更新登记信息
     *
     * @param winner
     */
    public void updateCheckInInfo(Winner winner);

    /**
     * 根据主键查询中奖用户信息
     *
     * @param drawId
     * @return
     */
    public Winner selectWinnerById(Long drawId);

    /**
     * 统计指定日期的奖品数据
     * @param activityId
     * @return
     */
    public Map<Integer, Integer> selectPrizesByDate(long activityId, Date startTime,Date endTime);

    /**
     * 统计总参与人数
     *
     * @param activityIds
     * @return
     */
    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds);

    /**
     * 统计中奖人数
     */
    public Integer getWinnerTotal (List<Long> activityIds, Date startDate, Date endDate);
}
