/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.activity.dao;

import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Collection;
import java.util.List;

/**
 * @author gaodan
 * @createdate 2016年8月22日
 * @desc
 */
public interface TxActivityCommonDao extends CommonDao<TxActivityCommon> {
    
    /**
     * 按照条件进行活动筛选
     * @param orgId
     * @param typeIds
     * @param pageDto
     * @param isSortedByPopular
     * @param status 活动状态 0：已关闭，1：未开始，2：进行中，3：已结束
     * @return
     */
    public List<TxActivityCommon> getTxActivityList(Long orgId, Collection<Integer> typeIds, PageDto pageDto, 
        Integer isSortedByPopular, Integer status);
    
    /**
     * 获取活动配置详情
     */
    public TxActivityCommon getTxActivityCommon(Long orgId, Integer typeId, Long activityId);
    
    /**
     * 获取机构已经创建活动总数
     * @param orgId
     * @return
     */
    public Integer getActivityTotal(Long orgId);

    /**
     * 查询未结束的活动
     * @param orgId
     * @return
     */
    public List<TxActivityCommon> selectUnEndedActivityList(long orgId);
    
}
