package com.baijia.tianxiao.dal.activity.dao;

import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;

/**
 * Created by liuxp on 16/1/8.
 */
public interface TemplateDao {
    List<Template> selectTemplateListByTypeId(Collection<Integer> typeIds,PageInfo page);

    public void updateTemplateUseCount(Long templateId);

    Template selectTemplateById(Integer templateId);
    
    /**
     * 按照条件筛选模板列表
     * @param typeIds  模板typeIds
     * @param pageDto
     * @param isSortedByPopular 是否按照人气进行排序，如果为null或者0，则按照创建时间进行排序
     * @return
     */
    public List<Template> getTemplateListByCondition(Collection<Integer> typeIds,PageDto pageDto, 
        Integer isSortedByPopular);

    List<Template> selectTemplateList();
}
