package com.baijia.tianxiao.dal.activity.dao;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Jan 10, 2016 11:21:10 PM
 * @desc : 活动的持久化类
 */
public interface ActivityDao {

    Long saveActivity(Activity activity);

    void update(Activity activity);

    /**
     * 活动列表
     * 
     * @param status :活动状态
     * @param lastId :上次活动列表返回时候的最后一条活动id , 允许为空，代表第一页
     * @param orgId :机构id
     * @return
     */
    List<Activity> listActivities(Integer status, Long lastId, Integer orgId, PageDto pageDto);

    /**
     * 取活动
     * 
     * @param id
     * @param orgId
     * @return
     */
    Activity getActivityByIdAndOrgId(Long id, Long orgId);

    /**
     * 根据活动ID查询活动
     *
     * @param id
     * @return
     */
    public Activity getActivityById(Long id);

    /**
     * 获取每个机构所有发活动id
     */
    public Map<Long, List<Long>> getActivityIdByOrgIds(List<Long> orgIds, Date startTime, Date endTime);

    /**
     * 获取已经存在的发活动的orgIds
     
     * @return
     */
    public List<Long> getExistOrgIds(List<Long> TianxiaoOrgIds);

    /**
     * 获取已经存在的发活动的orgIds 每一个orgId对应的键值是该机构发活动数
     * @param startDate   不为null则表示查询一段时间内的发活动
     * @param  endDate
     * @return
     */
    public Map<Long, Integer> getActivityCount(List<Long> orgIds, Date startDate, Date endDate);

    public List<Activity> selectCurrentActivityList(long orgId);

    Activity getActivityByIdAndOrgId(Long id, Long orgId, Integer isDel);
    
    //获取当前所有发活动bb_type =2 and c_type = 9;
    public List<Activity> getActivityList(PageDto pageDto);

}
