
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.commons.ConfigEnum;
import com.google.common.collect.Maps;

/**
 * @title Sex
 * @desc 性别
 * @date 2016年5月25日
 * @version 1.0
 */

public enum Sex {

    MAN(0, "男", ""),
    WOMAN(1, "女", ""),
    ;

    
    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (Sex p : values()) {
            map.put(p.getValue(), p.getLabel());
        }
    }
    
    public static String getLabel(Integer value) {
    	if(value==null){
    		return null;
    	}
        return  map.get(value.intValue());
    }
    
    
    private int value;
    private String label;
    private String img;

    private Sex(int value, String label, String img) {
        this.value = value;
        this.label = label;
        this.img = img;
    }

    public int getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }
    
    public String getImg(){
    	return img;
    }
    
    public static List<ConfigEnum> list(){
    	List<ConfigEnum> list = new ArrayList<ConfigEnum>();
    	for (Sex p : values()) {
    		 ConfigEnum po = new ConfigEnum();
    		 po.setValue(p.getValue());
    		 po.setLabel(p.getLabel());
    		 po.setImg(p.getImg());
    		 list.add(po);
    	}
    	return list;
    }
    
    
    public static List<Integer> listValues(){
    	List<Integer> list = new ArrayList<Integer>();
    	for (Sex p : values()) {
    		 list.add(p.getValue());
    	}
    	return list;
    }
    
}
