
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.constant;

import com.baijia.tianxiao.dal.commons.ConfigEnum;

import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0
 * @title CommentType
 * @desc 亲属关系
 * @date 2016年5月25日
 */

public enum Relatives {

    GRANDFATHER(1, "爷爷", ""),
    GRANDMOTHER(2, "奶奶", ""),
    MOTHER(3, "母亲", ""),
    FATHER(4, "父亲", "");

    private static Map<Integer, String> map = Maps.newHashMap();
    private static Map<String, Integer> nameMap = Maps.newHashMap();

    static {
        for (Relatives p : values()) {
            map.put(p.getValue(), p.getLabel());
        }
    }

    static {
        for (Relatives p : values()) {
            nameMap.put(p.getLabel(), p.getValue());
        }
    }

    public static String getLabel(Integer value) {
    	if(value==null){
    		return null;
    	}
        return map.get(value.intValue());
    }

    public static Integer getValue(String label) {
        return nameMap.get(label);
    }


    private int value;
    private String label;
    private String img;

    private Relatives(int value, String label, String img) {
        this.value = value;
        this.label = label;
        this.img = img;
    }

    public int getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    public String getImg() {
        return img;
    }

    public static List<ConfigEnum> list() {
        List<ConfigEnum> list = new ArrayList<ConfigEnum>();
        for (Relatives p : values()) {
            ConfigEnum po = new ConfigEnum();
            po.setValue(p.getValue());
            po.setLabel(p.getLabel());
            po.setImg(p.getImg());
            list.add(po);
        }
        return list;
    }

    public static List<Integer> listValues() {
        List<Integer> list = new ArrayList<Integer>();
        for (Relatives p : values()) {
            list.add(p.getValue());
        }
        return list;
    }
}
