
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @title OrgTeacherStatus
 * @desc TODO
 * @author cxm
 * @date 2016年1月8日
 * @version 1.0
 */
public enum OrgTeacherStatus {

    INVITING(0, "邀请中"),

    SIGNED(1, "已签约"),

    TERMINATED(2, "已解约"),

    REFUSE(3, "已拒绝"),

    INVALID(4, "已失效"),

    REVOKE(5, "撤销邀请"),

    ;

    private int code;

    private String note;

    private static Map<Integer, OrgTeacherStatus> map = Maps.newHashMap();

    private OrgTeacherStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (OrgTeacherStatus at : OrgTeacherStatus.values()) {
            map.put(at.code, at);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static OrgTeacherStatus getStatusByCode(Integer code) {
        return map.get(code);
    }

}
