/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository(value="tianxiao_dal_yunying_authorizerInfoDao")
public class AuthorizerInfoDaoImpl
extends JdbcTemplateDaoSupport<AuthorizerInfo>
implements AuthorizerInfoDao {
    private static final Logger log = LoggerFactory.getLogger(AuthorizerInfoDaoImpl.class);

    public AuthorizerInfoDaoImpl() {
        super(AuthorizerInfo.class);
    }

    @Override
    public void deleteByOrgId(Integer orgId) {
        HashMap<String, Integer> condition = new HashMap<String, Integer>();
        condition.put("orgId", orgId);
        this.delByCondition(condition);
    }

    @Override
    public void resetOngoingStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("update yunying.org_wechat_authorizer_info set fans_sync_status=:NOSTART,media_news_sync_status=:NOSTART ");
        sb.append("where fans_sync_status=:ONGOING or media_news_sync_status = :ONGOING");
        HashedMap params = new HashedMap();
        params.put("NOSTART", WechatDataSyncStatus.NOTSTART.getValue());
        params.put("ONGOING", WechatDataSyncStatus.ONGOING.getValue());
        log.debug("wechat - AuthorizerInfoServiceImpl - resetOngoing sql={},params={}", (Object)sb.toString(), (Object)params);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)params);
        log.debug("wechat - AuthorizerInfoServiceImpl - resetOngoing success");
    }

    @Override
    public void deleteByAuthorizerAppId(String authorizerAppId) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("authorizerAppId", authorizerAppId);
        this.delByCondition(condition);
    }

    @Override
    public AuthorizerInfo getByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        return (AuthorizerInfo)this.uniqueResult(builder);
    }

    @Override
    public AuthorizerInfo getByUserName(String userName) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userName", (Serializable)((Object)userName));
        return (AuthorizerInfo)this.uniqueResult(builder);
    }

    @Override
    public AuthorizerInfo getByAuthorizerAppId(String authorizerAppId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("authorizerAppId", (Serializable)((Object)authorizerAppId));
        return (AuthorizerInfo)this.uniqueResult(builder);
    }

    @Override
    public Map<Long, String> getExistOrgIds(List<Long> TianxiaoOrgIds) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, authorizer_app_id from yunying.org_wechat_authorizer_info where org_id in (:orgIds)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, String>>(){

            public Map<Long, String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, String> map = new HashMap<Long, String>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    String authorizer_app_id = rs.getString("authorizer_app_id");
                    map.put(orgId, authorizer_app_id);
                }
                return map;
            }
        });
    }
}

