/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class TxStudentCommentDaoImpl
extends JdbcTemplateDaoSupport<TxStudentComment>
implements TxStudentCommentDao {
    public TxStudentCommentDaoImpl() {
        super(TxStudentComment.class);
    }

    @Override
    public List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
        }
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<TxStudentComment> getComments(Long studentId, Long orgId, Integer type, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (type.intValue() == StudentType.CONSULT_USER.getCode()) {
            builder.eq("consultUserId", (Serializable)studentId);
        } else {
            builder.eq("userId", (Serializable)studentId);
        }
        builder.eq("orgId", (Serializable)orgId);
        if (null != page) {
            builder.setPage(page);
        }
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public void updateComment(Long consultUserId, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("consultUserId", (Serializable)consultUserId);
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        params.putAll(builder.collectConditionValue());
        this.getNamedJdbcTemplate().update(builder.toUpdateSql(new String[]{"userId"}), (Map)params);
    }
}

