/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.AutoMatchUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgStudentDaoImpl
extends JdbcTemplateDaoSupport<OrgStudent>
implements OrgStudentDao {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentDaoImpl.class);

    public OrgStudentDaoImpl() {
        super(OrgStudent.class);
    }

    @Override
    public OrgStudent getStudent(Long orgId, Long userId, Integer delStatus, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        if (delStatus != null && delStatus >= 0) {
            builder.eq("delStatus", (Serializable)delStatus);
        } else {
            builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        }
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudent> getNoPinyinStudentsByPage(PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentId(Long orgId, String mobile, Integer delStatus, String name, String ... propes) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name}), (Object)"\u5b66\u751f\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"\u5b66\u751f\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder builder = this.createSqlBuilder(propes);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            builder.eq("name", (Serializable)((Object)name));
        }
        if (StringUtils.isNotEmpty((CharSequence)mobile)) {
            Expression exp = Expressions.eq((String)"mobile", (Serializable)((Object)mobile));
            exp = Expressions.or((Expression)exp, (Expression)Expressions.eq((String)"showMobile", (Serializable)((Object)mobile)));
            builder.add(exp);
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudents(Long orgId, String searchKey, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchKey})) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"pinyin", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(page);
        builder.asc("name", true);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentList(Long orgId, String searchKey, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchKey})) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"pinyin", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(page);
        builder.asc("pinyin");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentsNotInUserIds(Long orgId, Collection<Long> usrIds, String searchKey, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotEmpty((CharSequence)searchKey)) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"pinyin", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (CollectionUtils.isNotEmpty(usrIds)) {
            builder.notin("userId", usrIds);
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(page);
        builder.asc("name", true);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudents(final Long orgId, Collection<Long> userIds, final Integer delStatus, final PageDto page, final String ... queryProps) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                if (page != null) {
                    builder.setPage(page);
                }
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                builder.in("userId", querySet);
                builder.desc("createTime");
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgStudent> getStudents(Date createTime, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.gt("createTime", (Serializable)createTime);
        builder.setPage(page);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudents(final Long orgId, Collection<String> mobiles, final Integer delStatus, final String ... queryProps) {
        if (CollectionUtils.isEmpty(mobiles)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                builder.in("mobile", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgStudent getStudentByMobileAndOrgId(Long orgId, String mobile, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudent> getStudentByMobileAndOrgId(Long orgId, String mobile, Integer maxSize, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentByOpenIdAndOrgId(Long orgId, String weixinOpenId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("weixin", (Serializable)((Object)weixinOpenId));
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public OrgStudent getLastStudentByMobileOrParentMobile(Long orgId, String mobile, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        Expression expression = Expressions.or((Expression)Expressions.eq((String)"mobile", (Serializable)((Object)mobile)), (Expression)Expressions.and((Expression)Expressions.ne((String)"mobile", (Serializable)((Object)mobile)), (Expression)Expressions.eq((String)"parentMobile", (Serializable)((Object)mobile))));
        builder.add(expression);
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudent> getStudentByIds(final Long orgId, Collection<Long> studentIds, final String ... propes) {
        if (studentIds.isEmpty()) {
            log.warn("student ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(propes);
                builder.in("id", querySet);
                builder.eq("orgId", (Serializable)orgId);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return students;
    }

    @Override
    public List<OrgStudent> getStudentByUserIds(final Long orgId, Collection<Long> userIds, final String ... propes) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(propes);
                builder.in("userId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return students;
    }

    @Override
    public List<OrgStudent> getPageStudentByUserIds(final Long orgId, Collection<Long> userIds, final PageDto pageDto) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("userId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.setPage(pageDto);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return students;
    }

    @Override
    public Long getUserId(Long studentId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("id", (Serializable)studentId);
        return (Long)this.queryForObject(builder, Long.class);
    }

    @Override
    public Long getStudentId(Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("userId", (Serializable)userId);
        return (Long)this.queryForObject(builder, Long.class);
    }

    @Override
    public Map<Long, Long> getStudentIdUserIdMap(Collection<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Long>>(){

            public Map<Long, Long> doQuery(Collection<Long> studentIds) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("id", studentIds);
                final HashMap result = Maps.newHashMap();
                OrgStudentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("id"), rs.getLong("userId"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, final Long orgId) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Long>>(){

            public Map<Long, Long> doQuery(Collection<Long> userIds) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("userId", userIds);
                builder.eq("orgId", (Serializable)orgId);
                final HashMap result = Maps.newHashMap();
                OrgStudentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("userId"), rs.getLong("id"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, String> getStudentNameMap(Collection<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, String>>(){

            public Map<Long, String> doQuery(Collection<Long> studentIds) {
                long current = System.currentTimeMillis();
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[]{"id", "name", "nickName", "mobile"});
                builder.in("id", studentIds);
                final HashMap result = Maps.newHashMap();
                OrgStudentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        if (StringUtils.isBlank((CharSequence)rs.getString("name"))) {
                            if (StringUtils.isNotBlank((CharSequence)rs.getString("nickName"))) {
                                result.put(rs.getLong("id"), rs.getString("nickName"));
                            } else {
                                result.put(rs.getLong("id"), MaskUtil.maskMobile((String)rs.getString("mobile")));
                            }
                        } else {
                            result.put(rs.getLong("id"), rs.getString("name"));
                        }
                    }
                });
                log.debug("cost:{}ms", (Object)(System.currentTimeMillis() - current));
                return result;
            }
        });
    }

    @Override
    public Map<Long, OrgStudent> getStudentMap(Collection<Long> userIds, final Long orgId) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.eq("orgId", (Serializable)orgId);
                builder.in("userId", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

            public Long apply(OrgStudent arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public List<OrgStudent> getUserByRemindTime(Date startTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)new Date());
        builder.gt("nextRemindTime", (Serializable)startTime);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getUserByRemindTime(Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)endTime);
        builder.ge("nextRemindTime", (Serializable)startTime);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(new String[]{"name", "nickName"});
        builder.ne("mobile", (Serializable)((Object)""));
        builder.dateformat("birthday", format, value);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.group("mobile");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentsByUserIdsAndOrgIds(final Collection<Long> orgIds, Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds) || CollectionUtils.isEmpty(orgIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("orgId", orgIds);
                builder.in("userId", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgStudent getStudentByMobileAndName(Long orgId, String mobile, String studentName) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("name", (Serializable)((Object)studentName));
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudent> searchStudentByCustomParam(long orgId, AutoMatchQueryRequest params, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (params != null) {
            AutoMatchUtils.wrap(builder, params);
        } else {
            builder.desc("createTime");
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getStudentTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from yunying.org_students where org_id in (:orgIds) and del_status = 0";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgWechatAuthorizerOfStudentTotal(List<Long> TianxiaoOrgIds) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from yunying.org_students where org_id in (:orgIds) and weixin != '' and del_status = 0 group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public void refreshOrgStudent(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.org_students set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public Map<Long, OrgStudent> getOrgStudentMapByUserIds(Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("userId", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

            public Long apply(OrgStudent arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public Map<String, Integer> getStudentTotalMap(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select count(id) count, DATE_FORMAT(create_time,'%y-%m-%d') createTime from yunying.org_students where org_id in (:orgIds) and del_status = 0";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql = sql + " group by MONTH(create_time), DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String createTime = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    map.put(createTime, count);
                    log.info("createTime===========" + rs.getString("createTime") + "count==========" + count);
                }
                return map;
            }
        });
    }

    @Override
    public Integer getStudentSum(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgStudent> getStudentByUserId(Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        return this.queryList(builder);
    }

    @Override
    public Integer getStudentCountByTime(Date startTime, Date endTime, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.le("createTime", (Serializable)endTime);
        builder.ge("createTime", (Serializable)startTime);
        return (Integer)this.queryForObject(builder, Integer.class);
    }
}

