/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.callservice.dao.impl;

import com.baijia.tianxiao.dal.callservice.constant.PartyCallType;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class CallServiceInfoDaoImpl
extends JdbcTemplateDaoSupport<CallServiceInfo>
implements CallServiceInfoDao {
    public CallServiceInfoDaoImpl() {
        super(CallServiceInfo.class);
    }

    @Override
    public Map<String, Object> queryCallCountAndTime(String mobile, Long callParty, PartyCallType callType) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be null");
        Preconditions.checkArgument((callParty != null && callParty > 0L ? 1 : 0) != 0, (Object)"call party is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.max("createTime", "MAX_TIME");
        builder.eq("callSubscriberNum", (Serializable)((Object)mobile));
        builder.eq("calledParty", (Serializable)callParty);
        if (callType != null) {
            builder.eq("callType", (Serializable)Integer.valueOf(callType.getCode()));
        }
        return this.getNamedJdbcTemplate().queryForMap(builder.toSql(), builder.collectConditionValue());
    }

    @Override
    public Integer getTotalDurationByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.sum("duration");
        builder.eq("callSubscriber", (Serializable)Long.valueOf(orgId.intValue()));
        builder.eq("month", (Serializable)((Object)DateUtil.getCurrentYM()));
        Integer sum = (Integer)this.queryForObject(builder, Integer.class);
        if (sum == null) {
            return 0;
        }
        return sum;
    }
}

