/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrgTeacherDaoImpl
extends JdbcTemplateDaoSupport<OrgTeacher>
implements OrgTeacherDao {
    public OrgTeacherDaoImpl() {
        super(OrgTeacher.class);
    }

    @Override
    public List<Long> getTeacherIds(Long orgId, Integer status) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgTeacher> getTeacherByOpenIdAndOrgId(Long orgId, String weixinOpenId, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("weixin", (Serializable)((Object)weixinOpenId));
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByMobileAndOrgId(Long orgId, String mobile, Integer maxSize, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("id");
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByUserIdAndOrgId(Long orgId, Long userId, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }
}

