/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.course.po.OrgCourseGroup;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="orgCourseGroupDao")
public class OrgCourseGroupDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseGroup>
implements OrgCourseGroupDao {
    private static final Logger log = LoggerFactory.getLogger(OrgCourseGroupDaoImpl.class);

    public OrgCourseGroupDaoImpl() {
        super(OrgCourseGroup.class);
    }

    @Override
    public List<OrgCourseGroup> getOrgCourseGroupList(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("displayOrder");
        return this.queryList(builder);
    }

    @Override
    public List<Integer> getOrgCourseGroupIdList(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("displayOrder");
        return this.queryForList(builder, Integer.class);
    }

    @Override
    public Map<Integer, Integer> getCourseCountMap(Integer orgId, Collection<Long> courseIds, Collection<Integer> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyMap();
        }
        String sql = "select course_group_id as groupId, count(course_id) as courseCnt from yunying.org_course_group_relate where is_deleted=0 and course_type=4 and course_group_id in(:groupIds) and course_id in (:courseIds) group by course_group_id";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("groupIds", groupIds);
        paramMap.put("courseIds", courseIds);
        final HashMap map = Maps.newHashMap();
        log.debug("sql={},param={}", (Object)sql, (Object)paramMap);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                map.put(rs.getInt("groupId"), rs.getInt("courseCnt"));
            }
        });
        log.debug("result={}", (Object)map);
        return map;
    }

    @Override
    public List<String> getDistinctSubject(Integer orgId, PageDto pageDto) {
        String sql = "select distinct name from yunying.org_course_group_relate oc,yunying.org_course_group og where oc.course_group_id=og.id and og.org_id=? and oc.is_deleted=0 order by og.display_order desc limit ?, ?";
        List names = this.getNamedJdbcTemplate().getJdbcOperations().query(sql, new Object[]{orgId, pageDto.firstNum(), pageDto.getPageSize()}, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("name");
            }
        });
        return names;
    }

    @Override
    public int countByName(Integer orgId, String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("name", (Serializable)((Object)name));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isDeleted", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }
}

