/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.callservice.constant;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum PartyCallType {
    S2T(0),
    T2S(1),
    S2O(2),
    T2O(3),
    O2S(4),
    O2T(5),
    T2T(6),
    O2O(7),
    S2S(8),
    UNKNOW(10),
    VIDEO_BROADCAST(11);

    private int code;
    private static Map<String, PartyCallType> callTypeMaping;
    private static Set<PartyCallType> studentSubsriberType;
    private static Set<PartyCallType> studentCalledType;
    private static Set<PartyCallType> teacherSubsriberType;
    private static Set<PartyCallType> teacherCalledType;
    private static Set<PartyCallType> orgSubsriberType;
    private static Set<PartyCallType> orgCalledType;
    private static Set<PartyCallType> orgType;

    private PartyCallType(Integer code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static PartyCallType getCallTypeByCode(String codeStr) {
        return callTypeMaping.get(codeStr);
    }

    public static Set<PartyCallType> getStudentSubsriberType() {
        return studentSubsriberType;
    }

    public static Set<PartyCallType> getStudentCalledType() {
        return studentCalledType;
    }

    public static Set<PartyCallType> getTeacherSubsriberType() {
        return teacherSubsriberType;
    }

    public static Set<PartyCallType> getTeacherCalledType() {
        return teacherCalledType;
    }

    public static Set<PartyCallType> getOrgSubsriberType() {
        return orgSubsriberType;
    }

    public static Set<PartyCallType> getOrgCalledType() {
        return orgCalledType;
    }

    public static Set<PartyCallType> getOrgType() {
        return orgType;
    }

    static {
        callTypeMaping = new HashMap<String, PartyCallType>();
        studentSubsriberType = new HashSet<PartyCallType>();
        studentCalledType = new HashSet<PartyCallType>();
        teacherSubsriberType = new HashSet<PartyCallType>();
        teacherCalledType = new HashSet<PartyCallType>();
        orgSubsriberType = new HashSet<PartyCallType>();
        orgCalledType = new HashSet<PartyCallType>();
        orgType = new HashSet<PartyCallType>();
        for (PartyCallType type : PartyCallType.values()) {
            callTypeMaping.put(type.code + "", type);
            if (type.name().startsWith("S")) {
                studentSubsriberType.add(type);
            } else if (type.name().startsWith("T")) {
                teacherSubsriberType.add(type);
            } else if (type.name().startsWith("O")) {
                orgSubsriberType.add(type);
                orgType.add(type);
            }
            if (type.name().endsWith("S")) {
                studentCalledType.add(type);
                continue;
            }
            if (type.name().endsWith("T")) {
                teacherCalledType.add(type);
                continue;
            }
            if (!type.name().endsWith("O")) continue;
            orgCalledType.add(type);
            orgType.add(type);
        }
    }
}

